/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.provider;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.bytestreams.ibb.provider.OpenIQProvider;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class OpenIQProviderTest
extends InitExtensions {
    private static Properties outputProperties = new Properties();

    public OpenIQProviderTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test
    public void shouldCorrectlyParseIQStanzaAttribute() throws Exception {
        String control = XMLBuilder.create((String)"open").a("xmlns", "http://jabber.org/protocol/ibb").a("block-size", "4096").a("sid", "i781hf64").a("stanza", "iq").asString(outputProperties);
        OpenIQProvider oip = new OpenIQProvider();
        Open open = (Open)oip.parse(OpenIQProviderTest.getParser(control));
        Assert.assertEquals((Object)InBandBytestreamManager.StanzaType.IQ, (Object)open.getStanza());
    }

    @Test
    public void shouldCorrectlyParseMessageStanzaAttribute() throws Exception {
        String control = XMLBuilder.create((String)"open").a("xmlns", "http://jabber.org/protocol/ibb").a("block-size", "4096").a("sid", "i781hf64").a("stanza", "message").asString(outputProperties);
        OpenIQProvider oip = new OpenIQProvider();
        Open open = (Open)oip.parse(OpenIQProviderTest.getParser(control));
        Assert.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)open.getStanza());
    }

    private static XmlPullParser getParser(String control) throws XmlPullParserException, IOException {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput((Reader)new StringReader(control));
        while (parser.next() != 2 || !parser.getName().equals("open")) {
        }
        return parser;
    }
}

