/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class Socks5ProxyTest {
    static final String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();

    @Test
    public void shouldBeASingleton() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5Proxy proxy1 = Socks5Proxy.getSocks5Proxy();
        Socks5Proxy proxy2 = Socks5Proxy.getSocks5Proxy();
        Assert.assertNotNull((Object)proxy1);
        Assert.assertNotNull((Object)proxy2);
        Assert.assertSame((Object)proxy1, (Object)proxy2);
    }

    @Test
    public void shouldNotBeRunningIfDisabled() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        Assert.assertFalse((boolean)proxy.isRunning());
    }

    @Test
    public void shouldUseFreePortOnNegativeValues() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        Assert.assertFalse((boolean)proxy.isRunning());
        ServerSocket serverSocket = new ServerSocket(0);
        Socks5Proxy.setLocalSocks5ProxyPort((int)(-serverSocket.getLocalPort()));
        proxy.start();
        Assert.assertTrue((boolean)proxy.isRunning());
        serverSocket.close();
        Assert.assertTrue((proxy.getPort() > serverSocket.getLocalPort() ? 1 : 0) != 0);
    }

    @Test
    public void shouldPreserveAddressOrderOnInsertions() {
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        ArrayList<String> addresses = new ArrayList<String>(proxy.getLocalAddresses());
        addresses.add("1");
        addresses.add("2");
        addresses.add("3");
        for (String address : addresses) {
            proxy.addLocalAddress(address);
        }
        List localAddresses = proxy.getLocalAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            Assert.assertEquals(addresses.get(i), localAddresses.get(i));
        }
    }

    @Test
    public void shouldPreserveAddressOrderOnReplace() {
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        ArrayList<String> addresses = new ArrayList<String>(proxy.getLocalAddresses());
        addresses.add("1");
        addresses.add("2");
        addresses.add("3");
        proxy.replaceLocalAddresses(addresses);
        List localAddresses = proxy.getLocalAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            Assert.assertEquals(addresses.get(i), localAddresses.get(i));
        }
    }

    @Test
    public void shouldNotReturnMultipleSameAddress() {
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        proxy.addLocalAddress("same");
        proxy.addLocalAddress("same");
        proxy.addLocalAddress("same");
        int sameCount = 0;
        for (String localAddress : proxy.getLocalAddresses()) {
            if (!"same".equals(localAddress)) continue;
            ++sameCount;
        }
        Assert.assertEquals((long)1L, (long)sameCount);
    }

    @Test
    public void shouldCloseSocketIfNoSocks5Request() throws Exception {
        int res;
        Socks5Proxy.setLocalSocks5ProxyPort((int)7890);
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        proxy.start();
        Socket socket = new Socket(loopbackAddress, proxy.getPort());
        OutputStream out = socket.getOutputStream();
        out.write(new byte[]{1, 2, 3});
        try {
            res = socket.getInputStream().read();
        }
        catch (SocketException e) {
            res = -1;
        }
        Assert.assertEquals((long)-1L, (long)res);
        proxy.stop();
    }

    @Test
    public void shouldRespondWithErrorIfNoSupportedAuthenticationMethod() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)7890);
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        proxy.start();
        Socket socket = new Socket(loopbackAddress, proxy.getPort());
        OutputStream out = socket.getOutputStream();
        out.write(new byte[]{5, 1, 2});
        InputStream in = socket.getInputStream();
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)-1L, (long)((byte)in.read()));
        Assert.assertEquals((long)-1L, (long)in.read());
        proxy.stop();
    }

    @Test
    public void shouldRespondWithErrorIfConnectionIsNotAllowed() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)7890);
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        proxy.start();
        Socket socket = new Socket(loopbackAddress, proxy.getPort());
        OutputStream out = socket.getOutputStream();
        out.write(new byte[]{5, 1, 0});
        InputStream in = socket.getInputStream();
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, 0, 0, 3, 1, -86, 0, 0});
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertFalse((0 == (byte)in.read() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)3L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)-86L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)-1L, (long)in.read());
        proxy.stop();
    }

    @Test
    public void shouldSuccessfullyEstablishConnection() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)7890);
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        proxy.start();
        Assert.assertTrue((boolean)proxy.isRunning());
        String digest = new String(new byte[]{-86}, "UTF-8");
        proxy.addTransfer(digest);
        Socket socket = new Socket(loopbackAddress, proxy.getPort());
        OutputStream out = socket.getOutputStream();
        out.write(new byte[]{5, 1, 0});
        InputStream in = socket.getInputStream();
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, 0, 0, 3, 1, -86, 0, 0});
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)3L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)-86L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Thread.sleep(200L);
        Socket remoteSocket = proxy.getSocket(digest);
        proxy.removeTransfer(digest);
        OutputStream remoteOut = remoteSocket.getOutputStream();
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        remoteOut.write(data);
        remoteOut.flush();
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)data[i], (long)in.read());
        }
        remoteSocket.close();
        Assert.assertEquals((long)-1L, (long)in.read());
        proxy.stop();
    }

    @After
    public void cleanup() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)true);
        Socks5Proxy.setLocalSocks5ProxyPort((int)7777);
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        try {
            String address = InetAddress.getLocalHost().getHostAddress();
            ArrayList<String> addresses = new ArrayList<String>();
            addresses.add(address);
            socks5Proxy.replaceLocalAddresses(addresses);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        socks5Proxy.stop();
    }
}

