/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion;

import org.hamcrest.Matcher;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.test.util.CharsequenceEquals;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.iqversion.VersionManager;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest
extends InitExtensions {
    @Test
    public void checkProvider() throws Exception {
        String control = "<iq from='capulet.lit' to='juliet@capulet.lit/balcony' id='s2c1' type='get'><query xmlns='jabber:iq:version'/></iq>";
        DummyConnection con = new DummyConnection();
        con.connect();
        VersionManager.setAutoAppendSmackVersion((boolean)false);
        VersionManager.getInstanceFor((XMPPConnection)con).setVersion("Test", "0.23", "DummyOS");
        IQ versionRequest = (IQ)PacketParserUtils.parseStanza((String)control);
        Assert.assertTrue((boolean)(versionRequest instanceof Version));
        con.processStanza((Stanza)versionRequest);
        Stanza replyPacket = (Stanza)con.getSentPacket();
        Assert.assertTrue((boolean)(replyPacket instanceof Version));
        Version reply = (Version)replyPacket;
        Assert.assertThat((Object)"capulet.lit", (Matcher)CharsequenceEquals.equalsCharSequence((CharSequence)reply.getTo()));
        Assert.assertEquals((Object)"s2c1", (Object)reply.getStanzaId());
        Assert.assertEquals((Object)IQ.Type.result, (Object)reply.getType());
        Assert.assertEquals((Object)"Test", (Object)reply.getName());
        Assert.assertEquals((Object)"0.23", (Object)reply.getVersion());
        Assert.assertEquals((Object)"DummyOS", (Object)reply.getOs());
    }
}

