/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.test.util.CharsequenceEquals;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.ping.PingManager;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class PingTest
extends InitExtensions {
    @Test
    public void checkProvider() throws Exception {
        String control = "<iq from='capulet.lit' to='juliet@capulet.lit/balcony' id='s2c1' type='get'><ping xmlns='urn:xmpp:ping'/></iq>";
        DummyConnection con = new DummyConnection();
        con.connect();
        PingManager.getInstanceFor((XMPPConnection)con);
        IQ pingRequest = (IQ)PacketParserUtils.parseStanza((String)control);
        Assert.assertTrue((boolean)(pingRequest instanceof Ping));
        con.processStanza((Stanza)pingRequest);
        Stanza pongPacket = (Stanza)con.getSentPacket();
        Assert.assertTrue((boolean)(pongPacket instanceof IQ));
        IQ pong = (IQ)pongPacket;
        Assert.assertThat((Object)"capulet.lit", (Matcher)CharsequenceEquals.equalsCharSequence((CharSequence)pong.getTo()));
        Assert.assertEquals((Object)"s2c1", (Object)pong.getStanzaId());
        Assert.assertEquals((Object)IQ.Type.result, (Object)pong.getType());
    }

    @Test
    public void checkSendingPing() throws InterruptedException, SmackException, IOException, XMPPException {
        ThreadedDummyConnection dummyCon = PingTest.getAuthentiactedDummyConnection();
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)dummyCon);
        try {
            pinger.ping((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG);
        }
        catch (SmackException smackException) {
            // empty catch block
        }
        Stanza sentPacket = (Stanza)dummyCon.getSentPacket();
        Assert.assertTrue((boolean)(sentPacket instanceof Ping));
    }

    @Test
    public void checkSuccessfulPing() throws Exception {
        ThreadedDummyConnection threadedCon = PingTest.getAuthentiactedDummyConnection();
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)threadedCon);
        boolean pingSuccess = pinger.ping((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG);
        Assert.assertTrue((boolean)pingSuccess);
    }

    @Test
    public void checkFailedPingOnTimeout() throws SmackException, IOException, XMPPException, InterruptedException {
        DummyConnection dummyCon = PingTest.getAuthenticatedDummyConnectionWithoutIqReplies();
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)dummyCon);
        try {
            pinger.ping((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG);
        }
        catch (SmackException.NoResponseException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void checkFailedPingToEntityError() throws Exception {
        ThreadedDummyConnection threadedCon = PingTest.getAuthentiactedDummyConnection();
        String reply = "<iq type='error' id='qrzSp-16' to='test@myserver.com'><ping xmlns='urn:xmpp:ping'/><error type='cancel'><service-unavailable xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></iq>";
        IQ serviceUnavailable = (IQ)PacketParserUtils.parseStanza((String)reply);
        threadedCon.addIQReply(serviceUnavailable);
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)threadedCon);
        boolean pingSuccess = pinger.ping((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG);
        Assert.assertFalse((boolean)pingSuccess);
    }

    @Test
    public void checkPingToServerSuccess() throws Exception {
        ThreadedDummyConnection con = PingTest.getAuthentiactedDummyConnection();
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)con);
        boolean pingSuccess = pinger.pingMyServer();
        Assert.assertTrue((boolean)pingSuccess);
    }

    @Test
    public void checkPingToServerError() throws Exception {
        ThreadedDummyConnection con = PingTest.getAuthentiactedDummyConnection();
        String reply = "<iq type='error' id='qrzSp-16' to='test@myserver.com' from='" + con.getXMPPServiceDomain() + "'>" + "<ping xmlns='urn:xmpp:ping'/>" + "<error type='cancel'>" + "<service-unavailable xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>" + "</error>" + "</iq>";
        IQ serviceUnavailable = (IQ)PacketParserUtils.parseStanza((String)reply);
        con.addIQReply(serviceUnavailable);
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)con);
        boolean pingSuccess = pinger.pingMyServer();
        Assert.assertTrue((boolean)pingSuccess);
    }

    @Test
    public void checkPingToServerTimeout() throws SmackException, IOException, XMPPException, InterruptedException {
        DummyConnection con = PingTest.getAuthenticatedDummyConnectionWithoutIqReplies();
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)con);
        boolean res = pinger.pingMyServer();
        Assert.assertFalse((boolean)res);
    }

    @Test
    public void checkSuccessfulDiscoRequest() throws Exception {
        ThreadedDummyConnection con = PingTest.getAuthentiactedDummyConnection();
        DiscoverInfo info = new DiscoverInfo();
        info.addFeature("urn:xmpp:ping");
        String reply = "<iq type='result' id='qrzSp-16' to='test@myserver.com'><query xmlns='http://jabber.org/protocol/disco#info'><identity category='client' type='pc' name='Pidgin'/><feature var='urn:xmpp:ping'/></query></iq>";
        IQ discoReply = (IQ)PacketParserUtils.parseStanza((String)reply);
        con.addIQReply(discoReply);
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)con);
        boolean pingSupported = pinger.isPingSupported((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG);
        Assert.assertTrue((boolean)pingSupported);
    }

    @Test
    public void checkUnuccessfulDiscoRequest() throws Exception {
        ThreadedDummyConnection con = PingTest.getAuthentiactedDummyConnection();
        DiscoverInfo info = new DiscoverInfo();
        info.addFeature("urn:xmpp:ping");
        String reply = "<iq type='result' id='qrzSp-16' to='test@myserver.com'><query xmlns='http://jabber.org/protocol/disco#info'><identity category='client' type='pc' name='Pidgin'/><feature var='urn:xmpp:noping'/></query></iq>";
        IQ discoReply = (IQ)PacketParserUtils.parseStanza((String)reply);
        con.addIQReply(discoReply);
        PingManager pinger = PingManager.getInstanceFor((XMPPConnection)con);
        boolean pingSupported = pinger.isPingSupported((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG);
        Assert.assertFalse((boolean)pingSupported);
    }

    private static ThreadedDummyConnection getAuthentiactedDummyConnection() throws SmackException, IOException, XMPPException, InterruptedException {
        ThreadedDummyConnection connection = new ThreadedDummyConnection();
        connection.connect();
        connection.login();
        return connection;
    }

    private static DummyConnection getAuthenticatedDummyConnectionWithoutIqReplies() throws SmackException, IOException, XMPPException, InterruptedException {
        DummyConnection con = new DummyConnection();
        con.setReplyTimeout(500L);
        con.connect();
        con.login();
        return con;
    }
}

