/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.provider;

import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.privacy.packet.Privacy;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;
import org.junit.Assert;
import org.junit.Test;

public class PrivacyProviderTest
extends InitExtensions {
    @Test
    public void parsePrivacyList() throws Exception {
        String xmlPrivacyList = "<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid'value='tybalt@example.com'action='deny'order='1'/><item action='allow' order='2'/></list></query></iq>";
        IQ iqPrivacyList = (IQ)PacketParserUtils.parseStanza((String)"<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid'value='tybalt@example.com'action='deny'order='1'/><item action='allow' order='2'/></list></query></iq>");
        Assert.assertTrue((boolean)(iqPrivacyList instanceof Privacy));
        Privacy privacyList = (Privacy)iqPrivacyList;
        List pl = privacyList.getPrivacyList("public");
        PrivacyItem first = (PrivacyItem)pl.get(0);
        Assert.assertEquals((Object)PrivacyItem.Type.jid, (Object)first.getType());
        Assert.assertEquals((Object)"tybalt@example.com", (Object)first.getValue());
        Assert.assertEquals((Object)false, (Object)first.isAllow());
        Assert.assertEquals((long)1L, (long)first.getOrder());
        PrivacyItem second = (PrivacyItem)pl.get(1);
        Assert.assertEquals((Object)true, (Object)second.isAllow());
        Assert.assertEquals((long)2L, (long)second.getOrder());
    }

    @Test
    public void parsePrivacyListWithFallThroughInclChildElements() throws Exception {
        String xmlPrivacyList = "<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid'value='tybalt@example.com'action='deny'order='1'/><item action='allow' order='2'><message/><presence-in/></item></list></query></iq>";
        IQ iqPrivacyList = (IQ)PacketParserUtils.parseStanza((String)"<iq type='result' id='getlist2' to='romeo@example.net/orchard'><query xmlns='jabber:iq:privacy'><list name='public'><item type='jid'value='tybalt@example.com'action='deny'order='1'/><item action='allow' order='2'><message/><presence-in/></item></list></query></iq>");
        Assert.assertTrue((boolean)(iqPrivacyList instanceof Privacy));
        Privacy privacyList = (Privacy)iqPrivacyList;
        List pl = privacyList.getPrivacyList("public");
        PrivacyItem first = (PrivacyItem)pl.get(0);
        Assert.assertEquals((Object)PrivacyItem.Type.jid, (Object)first.getType());
        Assert.assertEquals((Object)"tybalt@example.com", (Object)first.getValue());
        Assert.assertEquals((Object)false, (Object)first.isAllow());
        Assert.assertEquals((long)1L, (long)first.getOrder());
        PrivacyItem second = (PrivacyItem)pl.get(1);
        Assert.assertTrue((boolean)second.isAllow());
        Assert.assertEquals((long)2L, (long)second.getOrder());
        Assert.assertTrue((boolean)second.isFilterMessage());
        Assert.assertTrue((boolean)second.isFilterPresenceIn());
        Assert.assertFalse((boolean)second.isFilterPresenceOut());
        Assert.assertFalse((boolean)second.isFilterIQ());
    }
}

