/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp;

import java.util.Arrays;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;
import org.junit.Assert;
import org.junit.Test;

public class VCardTest
extends InitExtensions {
    private static final String MIME_TYPE = "testtype";
    private static final String VCARD_XML = "<vCard xmlns='vcard-temp'><PHOTO><BINVAL>" + VCardTest.getAvatarEncoded() + "</BINVAL><TYPE>" + "testtype" + "</TYPE></PHOTO></vCard>";

    @Test
    public void testParseFullVCardIQStanza() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><FN>User Name</FN><N><FAMILY>Name</FAMILY><GIVEN>User</GIVEN><MIDDLE>PJ</MIDDLE><PREFIX>Mr.</PREFIX><SUFFIX>III</SUFFIX></N><NICKNAME>User dude</NICKNAME><URL>http://www.igniterealtime.org</URL><BDAY>1970-17-03</BDAY><ORG><ORGNAME>Ignite Realtime</ORGNAME><ORGUNIT>Smack</ORGUNIT></ORG><TITLE>Programmer &amp; tester</TITLE><ROLE>Bug fixer</ROLE><TEL><WORK/><VOICE/><NUMBER>123-456-7890</NUMBER></TEL><TEL><WORK/><FAX/><NUMBER/></TEL><TEL><WORK/><MSG/><NUMBER/></TEL><ADR><WORK/><EXTADD></EXTADD><STREET>Work Street</STREET><LOCALITY>Work Locality</LOCALITY><REGION>Work Region</REGION><PCODE>Work Post Code</PCODE><CTRY>Work Country</CTRY></ADR><TEL><HOME/><VOICE/><NUMBER>123-098-7654</NUMBER></TEL><TEL><HOME/><FAX/><NUMBER/></TEL><TEL><HOME/><MSG/><NUMBER/></TEL><ADR><HOME/><EXTADD/><STREET/><LOCALITY>Home Locality</LOCALITY><REGION>Home Region</REGION><PCODE>Home Post Code</PCODE><CTRY>Home Country</CTRY></ADR><EMAIL><INTERNET/><PREF/><USERID>user@igniterealtime.org</USERID></EMAIL><EMAIL><INTERNET/><WORK/><USERID>work@igniterealtime.org</USERID></EMAIL><JABBERID>user@igniterealtime.org</JABBERID><DESC>&lt;Check out our website: http://www.igniterealtime.org&gt;</DESC><PHOTO><BINVAL>" + VCardTest.getAvatarEncoded() + "</BINVAL><TYPE>" + MIME_TYPE + "</TYPE></PHOTO>" + "</vCard>" + "</iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)request);
        Assert.assertEquals((Object)"User", (Object)vCard.getFirstName());
        Assert.assertEquals((Object)"Name", (Object)vCard.getLastName());
        Assert.assertEquals((Object)"PJ", (Object)vCard.getMiddleName());
        Assert.assertEquals((Object)"User dude", (Object)vCard.getNickName());
        Assert.assertEquals((Object)"Mr.", (Object)vCard.getPrefix());
        Assert.assertEquals((Object)"III", (Object)vCard.getSuffix());
        Assert.assertEquals((Object)"Programmer & tester", (Object)vCard.getField("TITLE"));
        Assert.assertEquals((Object)"Bug fixer", (Object)vCard.getField("ROLE"));
        Assert.assertEquals((Object)"<Check out our website: http://www.igniterealtime.org>", (Object)vCard.getField("DESC"));
        Assert.assertEquals((Object)"http://www.igniterealtime.org", (Object)vCard.getField("URL"));
        Assert.assertEquals((Object)"user@igniterealtime.org", (Object)vCard.getEmailHome());
        Assert.assertEquals((Object)"work@igniterealtime.org", (Object)vCard.getEmailWork());
        Assert.assertEquals((Object)"user@igniterealtime.org", (Object)vCard.getJabberId());
        Assert.assertEquals((Object)"Ignite Realtime", (Object)vCard.getOrganization());
        Assert.assertEquals((Object)"Smack", (Object)vCard.getOrganizationUnit());
        Assert.assertEquals((Object)"123-098-7654", (Object)vCard.getPhoneHome("VOICE"));
        Assert.assertEquals((Object)"123-456-7890", (Object)vCard.getPhoneWork("VOICE"));
        Assert.assertEquals((Object)"Work Locality", (Object)vCard.getAddressFieldWork("LOCALITY"));
        Assert.assertEquals((Object)"Work Region", (Object)vCard.getAddressFieldWork("REGION"));
        Assert.assertEquals((Object)"Work Post Code", (Object)vCard.getAddressFieldWork("PCODE"));
        Assert.assertEquals((Object)"Work Country", (Object)vCard.getAddressFieldWork("CTRY"));
        Assert.assertEquals((Object)"Home Locality", (Object)vCard.getAddressFieldHome("LOCALITY"));
        Assert.assertEquals((Object)"Home Region", (Object)vCard.getAddressFieldHome("REGION"));
        Assert.assertEquals((Object)"Home Post Code", (Object)vCard.getAddressFieldHome("PCODE"));
        Assert.assertEquals((Object)"Home Country", (Object)vCard.getAddressFieldHome("CTRY"));
        byte[] expectedAvatar = VCardTest.getAvatarBinary();
        Assert.assertTrue((boolean)Arrays.equals(vCard.getAvatar(), expectedAvatar));
        Assert.assertEquals((Object)MIME_TYPE, (Object)vCard.getAvatarMimeType());
    }

    @Test
    public void testNoWorkHomeSpecifier_EMAIL() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><EMAIL><USERID>foo@fee.www.bar</USERID></EMAIL></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><EMAIL><USERID>foo@fee.www.bar</USERID></EMAIL></vCard></iq>");
        Assert.assertEquals((Object)"foo@fee.www.bar", (Object)vCard.getEmailHome());
    }

    @Test
    public void testNoWorkHomeSpecifier_TEL() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><TEL><FAX/><NUMBER>3443233</NUMBER></TEL></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><TEL><FAX/><NUMBER>3443233</NUMBER></TEL></vCard></iq>");
        Assert.assertEquals((Object)"3443233", (Object)vCard.getPhoneWork("FAX"));
    }

    @Test
    public void testUnknownTopLevelElementAdded() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><UNKNOWN>1234</UNKNOWN></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><UNKNOWN>1234</UNKNOWN></vCard></iq>");
        Assert.assertEquals((Object)"1234", (Object)vCard.getField("UNKNOWN"));
    }

    @Test
    public void testUnknownComplexTopLevelElementNotAdded() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><UNKNOWN><FOO/></UNKNOWN></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><UNKNOWN><FOO/></UNKNOWN></vCard></iq>");
        Assert.assertEquals(null, (Object)vCard.getField("UNKNOWN"));
    }

    @Test
    public void testUnknownAddressElementNotAdded() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><ADR><UNKNOWN>1234</UNKNOWN></ADR></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><ADR><UNKNOWN>1234</UNKNOWN></ADR></vCard></iq>");
        Assert.assertEquals(null, (Object)vCard.getField("UNKNOWN"));
    }

    @Test
    public void testUnknownDeepElementNotAdded() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><UNKNOWN><UNKNOWN>1234</UNKNOWN></UNKNOWN></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><UNKNOWN><UNKNOWN>1234</UNKNOWN></UNKNOWN></vCard></iq>");
        Assert.assertEquals(null, (Object)vCard.getField("UNKNOWN"));
    }

    @Test
    public void testNoWorkHomeSpecifier_ADDR() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><ADR><STREET>Some street</STREET><FF>ddss</FF></ADR></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><ADR><STREET>Some street</STREET><FF>ddss</FF></ADR></vCard></iq>");
        Assert.assertEquals((Object)"Some street", (Object)vCard.getAddressFieldWork("STREET"));
        Assert.assertEquals((Object)"ddss", (Object)vCard.getAddressFieldWork("FF"));
    }

    @Test
    public void testFN() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><FN>kir max</FN></vCard></iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)"<iq id='v1' to='user@igniterealtime.org/mobile' type='result'><vCard xmlns='vcard-temp'><FN>kir max</FN></vCard></iq>");
        Assert.assertEquals((Object)"kir max", (Object)vCard.getField("FN"));
    }

    @Test
    public void testPhoto() throws Throwable {
        String request = "<iq id='v1' to='user@igniterealtime.org/mobile' type='result'>" + VCARD_XML + "</iq>";
        VCard vCard = (VCard)PacketParserUtils.parseStanza((String)request);
        byte[] avatar = vCard.getAvatar();
        String mimeType = vCard.getAvatarMimeType();
        Assert.assertEquals((Object)mimeType, (Object)MIME_TYPE);
        byte[] expectedAvatar = VCardTest.getAvatarBinary();
        Assert.assertTrue((boolean)Arrays.equals(avatar, expectedAvatar));
    }

    public static byte[] getAvatarBinary() {
        return Base64.decode((String)VCardTest.getAvatarEncoded());
    }

    private static String getAvatarEncoded() {
        return "/9j/4AAQSkZJRgABAQEASABIAAD/4QAWRXhpZgAATU0AKgAAAAgAAAAAAAD/2wBDAAUDBAQEAwUE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\nCgADtrKoqPLpKaXPVXUdPtnXTNUBLlTQR4xHlj+gHT/7pjw8oTsf/9k=";
    }
}

