/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.util.Verification;
import org.junit.Assert;

public class Protocol {
    public boolean printProtocol = false;
    private final Queue<Stanza> responses = new LinkedList<Stanza>();
    private final List<Verification<?, ?>[]> verificationList = new ArrayList<Verification<?, ?>[]>();
    private final List<Stanza> requests = new ArrayList<Stanza>();
    private final List<Stanza> responsesList = new ArrayList<Stanza>();

    public void addResponse(Stanza response, Verification<?, ?> ... verifications) {
        this.responses.offer(response);
        this.verificationList.add(verifications);
        this.responsesList.add(response);
    }

    public void verifyAll() {
        Assert.assertEquals((long)this.requests.size(), (long)this.responsesList.size());
        if (this.printProtocol) {
            System.out.println("=================== Start ===============\n");
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            Verification<?, ?>[] verifications;
            Stanza request = this.requests.get(i);
            Stanza response = this.responsesList.get(i);
            if (this.printProtocol) {
                System.out.println("------------------- Request -------------\n");
                System.out.println(Protocol.prettyFormat(request.toXML().toString()));
                System.out.println("------------------- Response ------------\n");
                if (response != null) {
                    System.out.println(Protocol.prettyFormat(response.toXML().toString()));
                } else {
                    System.out.println("No response");
                }
            }
            if ((verifications = this.verificationList.get(i)) == null) continue;
            for (Verification<?, ?> verification : verifications) {
                verification.verify(request, response);
            }
        }
        if (this.printProtocol) {
            System.out.println("=================== End =================\n");
        }
    }

    protected Queue<Stanza> getResponses() {
        return this.responses;
    }

    public List<Stanza> getRequests() {
        return this.requests;
    }

    private static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            return "error while formatting the XML: " + e.getMessage();
        }
    }

    private static String prettyFormat(String input) {
        return Protocol.prettyFormat(input, 2);
    }
}

