/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import java.util.ArrayList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.blocking.element.UnblockContactsIQ;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class UnblockContactsIQTest {
    private static final String unblockContactIQExample = "<iq id='unblock1' type='set'><unblock xmlns='urn:xmpp:blocking'><item jid='romeo@montague.net'/><item jid='pepe@montague.net'/></unblock></iq>";
    private static final String unblockContactPushIQExample = "<iq to='juliet@capulet.com/chamber' type='set' id='push3'><unblock xmlns='urn:xmpp:blocking'><item jid='romeo@montague.net'/><item jid='pepe@montague.net'/></unblock></iq>";
    private static final String unblockAllIQExample = "<iq id='unblock2' type='set'><unblock xmlns='urn:xmpp:blocking'/></iq>";
    private static final String unblockAllPushIQExample = "<iq to='juliet@capulet.com/chamber' type='set' id='push5'><unblock xmlns='urn:xmpp:blocking'/></iq>";

    @Test
    public void checkUnblockContactIQStanza() throws Exception {
        ArrayList<Jid> jids = new ArrayList<Jid>();
        jids.add(JidCreate.from((String)"romeo@montague.net"));
        jids.add(JidCreate.from((String)"pepe@montague.net"));
        UnblockContactsIQ unblockContactIQ = new UnblockContactsIQ(jids);
        unblockContactIQ.setStanzaId("unblock1");
        Assert.assertEquals((Object)unblockContactIQExample, (Object)unblockContactIQ.toXML().toString());
    }

    @Test
    public void checkUnblockContactPushIQ() throws Exception {
        IQ iq = (IQ)PacketParserUtils.parseStanza((String)unblockContactPushIQExample);
        UnblockContactsIQ unblockContactIQ = (UnblockContactsIQ)iq;
        Assert.assertEquals((Object)JidCreate.from((String)"romeo@montague.net"), unblockContactIQ.getJids().get(0));
        Assert.assertEquals((Object)JidCreate.from((String)"pepe@montague.net"), unblockContactIQ.getJids().get(1));
    }

    @Test
    public void checkUnblockAllIQStanza() throws Exception {
        UnblockContactsIQ unblockAllIQ = new UnblockContactsIQ(null);
        unblockAllIQ.setStanzaId("unblock2");
        Assert.assertEquals((Object)unblockAllIQExample, (Object)unblockAllIQ.toXML().toString());
    }

    @Test
    public void checkUnblockAllPushIQ() throws Exception {
        IQ iq = (IQ)PacketParserUtils.parseStanza((String)unblockAllPushIQExample);
        UnblockContactsIQ unblockAllIQ = (UnblockContactsIQ)iq;
        Assert.assertNull((Object)unblockAllIQ.getJids());
    }
}

