/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.provider;

import java.net.URI;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.util.XmppDateTime;

public class GeoLocationProviderTest
extends InitExtensions {
    @Test
    public void testGeoLocationProviderWithNoDatumSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>");
        Assert.assertNotNull((Object)messageWithGeoLocation);
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
        Assert.assertNotNull((Object)geoLocation);
        Assert.assertEquals((Object)23.0, (Object)geoLocation.getAccuracy());
        Assert.assertEquals((Object)1000.0, (Object)geoLocation.getAlt());
        Assert.assertEquals((Object)"Delhi", (Object)geoLocation.getArea());
        Assert.assertEquals((Object)10.0, (Object)geoLocation.getBearing());
        Assert.assertEquals((Object)"Small Building", (Object)geoLocation.getBuilding());
        Assert.assertEquals((Object)"India", (Object)geoLocation.getCountry());
        Assert.assertEquals((Object)"IN", (Object)geoLocation.getCountryCode());
        Assert.assertEquals((Object)"WGS84", (Object)geoLocation.getDatum());
        Assert.assertEquals((Object)"My Description", (Object)geoLocation.getDescription());
        Assert.assertNull((Object)geoLocation.getError());
        Assert.assertEquals((Object)"top", (Object)geoLocation.getFloor());
        Assert.assertEquals((Object)25.098345, (Object)geoLocation.getLat());
        Assert.assertEquals((Object)"awesome", (Object)geoLocation.getLocality());
        Assert.assertEquals((Object)77.992034, (Object)geoLocation.getLon());
        Assert.assertEquals((Object)"110085", (Object)geoLocation.getPostalcode());
        Assert.assertEquals((Object)"North", (Object)geoLocation.getRegion());
        Assert.assertEquals((Object)"small", (Object)geoLocation.getRoom());
        Assert.assertEquals((Object)250.0, (Object)geoLocation.getSpeed());
        Assert.assertEquals((Object)"Wall Street", (Object)geoLocation.getStreet());
        Assert.assertEquals((Object)"Unit Testing GeoLocation", (Object)geoLocation.getText());
        Assert.assertEquals((Object)XmppDateTime.parseDate((String)"2004-02-19"), (Object)geoLocation.getTimestamp());
        Assert.assertEquals((Object)"+5:30", (Object)geoLocation.getTzo());
        Assert.assertEquals((Object)new URI("http://xmpp.org"), (Object)geoLocation.getUri());
    }

    @Test
    public void testGeoLocationWithDatumSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><datum>Test Datum</datum><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><datum>Test Datum</datum><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>");
        Assert.assertNotNull((Object)messageWithGeoLocation);
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
        Assert.assertNotNull((Object)geoLocation);
        Assert.assertEquals((Object)23.0, (Object)geoLocation.getAccuracy());
        Assert.assertEquals((Object)1000.0, (Object)geoLocation.getAlt());
        Assert.assertEquals((Object)"Delhi", (Object)geoLocation.getArea());
        Assert.assertEquals((Object)10.0, (Object)geoLocation.getBearing());
        Assert.assertEquals((Object)"Small Building", (Object)geoLocation.getBuilding());
        Assert.assertEquals((Object)"India", (Object)geoLocation.getCountry());
        Assert.assertEquals((Object)"IN", (Object)geoLocation.getCountryCode());
        Assert.assertEquals((Object)"Test Datum", (Object)geoLocation.getDatum());
        Assert.assertEquals((Object)"My Description", (Object)geoLocation.getDescription());
        Assert.assertNull((Object)geoLocation.getError());
        Assert.assertEquals((Object)"top", (Object)geoLocation.getFloor());
        Assert.assertEquals((Object)25.098345, (Object)geoLocation.getLat());
        Assert.assertEquals((Object)"awesome", (Object)geoLocation.getLocality());
        Assert.assertEquals((Object)77.992034, (Object)geoLocation.getLon());
        Assert.assertEquals((Object)"110085", (Object)geoLocation.getPostalcode());
        Assert.assertEquals((Object)"North", (Object)geoLocation.getRegion());
        Assert.assertEquals((Object)"small", (Object)geoLocation.getRoom());
        Assert.assertEquals((Object)250.0, (Object)geoLocation.getSpeed());
        Assert.assertEquals((Object)"Wall Street", (Object)geoLocation.getStreet());
        Assert.assertEquals((Object)"Unit Testing GeoLocation", (Object)geoLocation.getText());
        Assert.assertEquals((Object)XmppDateTime.parseDate((String)"2004-02-19"), (Object)geoLocation.getTimestamp());
        Assert.assertEquals((Object)"+5:30", (Object)geoLocation.getTzo());
        Assert.assertEquals((Object)new URI("http://xmpp.org"), (Object)geoLocation.getUri());
    }

    @Test
    public void testGeoLocationWithoutAccuracySetAndWithErrorSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><error>90</error></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><error>90</error></geoloc></message>");
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
        Assert.assertEquals((Object)90.0, (Object)geoLocation.getError());
    }

    @Test
    public void testGeoLocationWithAccuracySetAndWithoutErrorSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy></geoloc></message>");
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
        Assert.assertEquals((Object)90.0, (Object)geoLocation.getAccuracy());
    }

    @Test
    public void testGeoLocationWithAccuracySetAndErrorSet() throws Exception {
        String geoLocationString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy><error>100</error></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>90</accuracy><error>100</error></geoloc></message>");
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
        Assert.assertEquals((Object)90.0, (Object)geoLocation.getAccuracy());
        Assert.assertNull((Object)geoLocation.getError());
    }
}

