/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.util.Protocol;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ConnectionUtils {
    public static XMPPConnection createMockedConnection(final Protocol protocol, EntityFullJid initiatorJID, DomainBareJid xmppServer) throws SmackException, XMPPException.XMPPErrorException, InterruptedException {
        XMPPConnection connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        Mockito.when((Object)connection.getUser()).thenReturn((Object)initiatorJID);
        Mockito.when((Object)connection.getXMPPServiceDomain()).thenReturn((Object)xmppServer);
        final StanzaCollector collector = (StanzaCollector)Mockito.mock(StanzaCollector.class);
        Mockito.when((Object)connection.createStanzaCollector((StanzaFilter)Matchers.isA(StanzaFilter.class))).thenReturn((Object)collector);
        Answer<StanzaCollector> collectorAndSend = new Answer<StanzaCollector>(){

            public StanzaCollector answer(InvocationOnMock invocation) throws Throwable {
                Stanza packet = (Stanza)invocation.getArguments()[0];
                protocol.getRequests().add(packet);
                return collector;
            }
        };
        Mockito.when((Object)connection.createStanzaCollectorAndSend((IQ)Matchers.isA(IQ.class))).thenAnswer((Answer)collectorAndSend);
        Answer<Object> addIncoming = new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                protocol.getRequests().add((Stanza)invocation.getArguments()[0]);
                return null;
            }
        };
        ((XMPPConnection)Mockito.doAnswer((Answer)addIncoming).when((Object)connection)).sendStanza((Stanza)Matchers.isA(Stanza.class));
        Answer<Stanza> answer = new Answer<Stanza>(){

            public Stanza answer(InvocationOnMock invocation) throws Throwable {
                return protocol.getResponses().poll();
            }
        };
        Mockito.when((Object)collector.nextResult((long)Matchers.anyInt())).thenAnswer((Answer)answer);
        Mockito.when((Object)collector.nextResult()).thenAnswer((Answer)answer);
        Answer<Stanza> answerOrThrow = new Answer<Stanza>(){

            public Stanza answer(InvocationOnMock invocation) throws Throwable {
                Stanza packet = protocol.getResponses().poll();
                if (packet == null) {
                    return packet;
                }
                XMPPException.XMPPErrorException.ifHasErrorThenThrow((Stanza)packet);
                return packet;
            }
        };
        Mockito.when((Object)collector.nextResultOrThrow()).thenAnswer((Answer)answerOrThrow);
        Mockito.when((Object)collector.nextResultOrThrow(Matchers.anyLong())).thenAnswer((Answer)answerOrThrow);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        return connection;
    }
}

