/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jxmpp.jid.Jid;

public final class GeoLocationManager
extends Manager {
    private static final Map<XMPPConnection, GeoLocationManager> INSTANCES = new WeakHashMap<XMPPConnection, GeoLocationManager>();

    public GeoLocationManager(XMPPConnection connection) {
        super(connection);
    }

    public static synchronized GeoLocationManager getInstanceFor(XMPPConnection connection) {
        GeoLocationManager geoLocationManager = INSTANCES.get(connection);
        if (geoLocationManager == null) {
            geoLocationManager = new GeoLocationManager(connection);
            INSTANCES.put(connection, geoLocationManager);
        }
        return geoLocationManager;
    }

    public void sendGeoLocationToJid(GeoLocation geoLocation, Jid jid) throws InterruptedException, SmackException.NotConnectedException {
        XMPPConnection connection = this.connection();
        Message geoLocationMessage = new Message(jid);
        geoLocationMessage.addExtension((ExtensionElement)geoLocation);
        connection.sendStanza((Stanza)geoLocationMessage);
    }

    public static boolean isGeoLocationMessage(Message message) {
        return GeoLocation.from(message) != null;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                GeoLocationManager.getInstanceFor(connection);
            }
        });
    }
}

