/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.jingle.element.JingleReason;
import org.junit.Test;

public class JingleReasonTest
extends SmackTestSuite {
    @Test
    public void parserTest() {
        TestCase.assertEquals((String)"<reason><success/></reason>", (String)JingleReason.Success.toXML().toString());
        TestCase.assertEquals((String)"<reason><busy/></reason>", (String)JingleReason.Busy.toXML().toString());
        TestCase.assertEquals((String)"<reason><cancel/></reason>", (String)JingleReason.Cancel.toXML().toString());
        TestCase.assertEquals((String)"<reason><connectivity-error/></reason>", (String)JingleReason.ConnectivityError.toXML().toString());
        TestCase.assertEquals((String)"<reason><decline/></reason>", (String)JingleReason.Decline.toXML().toString());
        TestCase.assertEquals((String)"<reason><expired/></reason>", (String)JingleReason.Expired.toXML().toString());
        TestCase.assertEquals((String)"<reason><unsupported-transports/></reason>", (String)JingleReason.UnsupportedTransports.toXML().toString());
        TestCase.assertEquals((String)"<reason><failed-transport/></reason>", (String)JingleReason.FailedTransport.toXML().toString());
        TestCase.assertEquals((String)"<reason><general-error/></reason>", (String)JingleReason.GeneralError.toXML().toString());
        TestCase.assertEquals((String)"<reason><gone/></reason>", (String)JingleReason.Gone.toXML().toString());
        TestCase.assertEquals((String)"<reason><media-error/></reason>", (String)JingleReason.MediaError.toXML().toString());
        TestCase.assertEquals((String)"<reason><security-error/></reason>", (String)JingleReason.SecurityError.toXML().toString());
        TestCase.assertEquals((String)"<reason><unsupported-applications/></reason>", (String)JingleReason.UnsupportedApplications.toXML().toString());
        TestCase.assertEquals((String)"<reason><timeout/></reason>", (String)JingleReason.Timeout.toXML().toString());
        TestCase.assertEquals((String)"<reason><failed-application/></reason>", (String)JingleReason.FailedApplication.toXML().toString());
        TestCase.assertEquals((String)"<reason><incompatible-parameters/></reason>", (String)JingleReason.IncompatibleParameters.toXML().toString());
        TestCase.assertEquals((String)"<reason><alternative-session><sid>1234</sid></alternative-session></reason>", (String)JingleReason.AlternativeSession((String)"1234").toXML().toString());
    }

    @Test(expected=NullPointerException.class)
    public void alternativeSessionEmptyStringTest() {
        JingleReason.AlternativeSession((String)"");
    }

    @Test(expected=NullPointerException.class)
    public void alternativeSessionNullStringTest() {
        JingleReason.AlternativeSession(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalArgumentTest() {
        JingleReason.Reason.fromString((String)"illegal-reason");
    }
}

