/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.junit.Test;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class JingleTest
extends SmackTestSuite {
    @Test(expected=IllegalArgumentException.class)
    public void emptyBuilderTest() {
        Jingle.Builder builder = Jingle.getBuilder();
        builder.build();
    }

    @Test(expected=NullPointerException.class)
    public void onlySessionIdBuilderTest() {
        String sessionId = "testSessionId";
        Jingle.Builder builder = Jingle.getBuilder();
        builder.setSessionId(sessionId);
        builder.build();
    }

    @Test
    public void parserTest() throws XmppStringprepException {
        String sessionId = "testSessionId";
        Jingle.Builder builder = Jingle.getBuilder();
        builder.setSessionId(sessionId);
        builder.setAction(JingleAction.session_initiate);
        FullJid romeo = JidCreate.fullFrom((String)"romeo@montague.lit/orchard");
        FullJid juliet = JidCreate.fullFrom((String)"juliet@capulet.lit/balcony");
        builder.setInitiator(romeo);
        builder.setResponder(juliet);
        Jingle jingle = builder.build();
        TestCase.assertNotNull((Object)jingle);
        TestCase.assertEquals((Object)romeo, (Object)jingle.getInitiator());
        TestCase.assertEquals((Object)juliet, (Object)jingle.getResponder());
        TestCase.assertEquals((Object)jingle.getAction(), (Object)JingleAction.session_initiate);
        TestCase.assertEquals((String)sessionId, (String)jingle.getSid());
        String xml = "<jingle xmlns='urn:xmpp:jingle:1' initiator='romeo@montague.lit/orchard' responder='juliet@capulet.lit/balcony' action='session-initiate' sid='" + sessionId + "'></jingle>";
        TestCase.assertTrue((boolean)jingle.toXML().toString().contains(xml));
    }
}

