/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_ibb;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.element.JingleIBBTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.provider.JingleIBBTransportProvider;
import org.junit.Test;

public class JingleIBBTransportTest
extends SmackTestSuite {
    @Test
    public void parserTest() throws Exception {
        String sid = StringUtils.randomString((int)24);
        short size = 8192;
        String xml = "<transport xmlns='urn:xmpp:jingle:transports:ibb:1' block-size='8192' sid='" + sid + "'/>";
        JingleIBBTransport transport = new JingleIBBTransport(size, sid);
        TestCase.assertEquals((String)xml, (String)transport.toXML(null).toString());
        TestCase.assertEquals((short)size, (short)transport.getBlockSize());
        TestCase.assertEquals((String)sid, (String)transport.getSessionId());
        JingleIBBTransport parsed = (JingleIBBTransport)new JingleIBBTransportProvider().parse(TestUtils.getParser((String)xml));
        TestCase.assertEquals((Object)transport, (Object)parsed);
        TestCase.assertTrue((boolean)transport.equals((Object)parsed));
        TestCase.assertEquals((String)xml, (String)parsed.toXML(null).toString());
        JingleIBBTransport transport1 = new JingleIBBTransport(1024);
        TestCase.assertEquals((short)1024, (short)transport1.getBlockSize());
        TestCase.assertNotSame((Object)transport, (Object)transport1);
        TestCase.assertNotSame((Object)transport.getSessionId(), (Object)transport1.getSessionId());
        TestCase.assertFalse((boolean)transport.equals(null));
        JingleIBBTransport transport2 = new JingleIBBTransport();
        TestCase.assertEquals((short)4096, (short)transport2.getBlockSize());
        TestCase.assertFalse((boolean)transport1.equals((Object)transport2));
        JingleIBBTransport transport3 = new JingleIBBTransport(-1024);
        TestCase.assertEquals((short)4096, (short)transport3.getBlockSize());
        TestCase.assertEquals((String)transport3.getNamespace(), (String)"urn:xmpp:jingle:transports:ibb:1");
        TestCase.assertEquals((String)transport3.getElementName(), (String)"transport");
        JingleIBBTransport transport4 = new JingleIBBTransport("session-id");
        TestCase.assertEquals((short)4096, (short)transport4.getBlockSize());
    }
}

