/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.time.packet.Time;
import org.junit.Assert;
import org.junit.Test;

public class TimeTest
extends InitExtensions {
    @Test
    public void parseCurrentTimeTest() {
        Calendar calendar = Calendar.getInstance();
        Time time = new Time(calendar);
        Date date = time.getTime();
        Date calendarDate = calendar.getTime();
        Assert.assertEquals((Object)calendarDate, (Object)date);
    }

    @Test
    public void negativeTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT-830"));
        Time time = new Time(calendar);
        Assert.assertEquals((Object)"-8:30", (Object)time.getTzo());
    }

    @Test
    public void positiveTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+830"));
        Time time = new Time(calendar);
        Assert.assertEquals((Object)"+8:30", (Object)time.getTzo());
    }
}

