/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5PacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.reflect.Whitebox;

public class InitiationListenerTest {
    private static final int TIMEOUT = 10000;
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final DomainBareJid xmppServer = JidTestUtil.DOMAIN_BARE_JID_1;
    private static final DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    private static final String proxyAddress = "127.0.0.1";
    private static final String sessionID = "session_id";
    private XMPPConnection connection;
    private Socks5BytestreamManager byteStreamManager;
    private InitiationListener initiationListener;
    private Bytestream initBytestream;

    @Before
    public void setup() {
        this.connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection);
        this.byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        this.initiationListener = (InitiationListener)Whitebox.getInternalState((Object)this.byteStreamManager, InitiationListener.class);
        this.initBytestream = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
        this.initBytestream.addStreamHost((Jid)proxyJID, proxyAddress, 7777);
    }

    @Test
    public void shouldRespondWithError() throws Exception {
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.timeout((long)10000L))).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)StanzaError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldInvokeListenerForAllRequests() throws Exception {
        Socks5BytestreamListener listener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)10000L))).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldInvokeListenerForUser() throws Exception {
        Socks5BytestreamListener listener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, (Jid)initiatorJID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)10000L))).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldNotInvokeListenerForUser() throws Exception {
        Socks5BytestreamListener listener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, JidCreate.from((String)("other_" + initiatorJID)));
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.timeout((long)10000L))).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)StanzaError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldNotInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        Socks5BytestreamListener allRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        Socks5BytestreamListener userRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, (Jid)initiatorJID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.timeout((long)10000L))).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        Socks5BytestreamListener allRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        Socks5BytestreamListener userRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, JidCreate.from((String)("other_" + initiatorJID)));
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.timeout((long)10000L))).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldIgnoreSocks5BytestreamRequestOnce() throws Exception {
        Socks5BytestreamListener allRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        Socks5BytestreamListener userRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, (Jid)initiatorJID);
        this.byteStreamManager.ignoreBytestreamRequestOnce(sessionID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.timeout((long)10000L))).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }
}

