/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.ExpirationCache;

public final class ServiceDiscoveryManager
extends Manager {
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static final List<DiscoInfoLookupShortcutMechanism> discoInfoLookupShortcutMechanisms = new ArrayList<DiscoInfoLookupShortcutMechanism>(2);
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private final Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private final Set<EntityCapabilitiesChangedListener> entityCapabilitiesChangedListeners = new CopyOnWriteArraySet<EntityCapabilitiesChangedListener>();
    private static final Map<XMPPConnection, ServiceDiscoveryManager> instances = new WeakHashMap<XMPPConnection, ServiceDiscoveryManager>();
    private final Set<String> features = new HashSet<String>();
    private DataForm extendedInfo = null;
    private final Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private final Cache<String, List<DiscoverInfo>> services = new ExpirationCache(25, 86400000L);

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection connection) {
        super(connection);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#items", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverItems discoverItems = (DiscoverItems)iqRequest;
                DiscoverItems response = new DiscoverItems();
                response.setType(IQ.Type.result);
                response.setTo(discoverItems.getFrom());
                response.setStanzaId(discoverItems.getStanzaId());
                response.setNode(discoverItems.getNode());
                NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                if (nodeInformationProvider != null) {
                    response.addItems(nodeInformationProvider.getNodeItems());
                    response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                } else if (discoverItems.getNode() != null) {
                    response.setType(IQ.Type.error);
                    response.setError(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.item_not_found));
                }
                return response;
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#info", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverInfo discoverInfo = (DiscoverInfo)iqRequest;
                DiscoverInfo response = new DiscoverInfo();
                response.setType(IQ.Type.result);
                response.setTo(discoverInfo.getFrom());
                response.setStanzaId(discoverInfo.getStanzaId());
                response.setNode(discoverInfo.getNode());
                if (discoverInfo.getNode() == null) {
                    ServiceDiscoveryManager.this.addDiscoverInfoTo(response);
                } else {
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                    if (nodeInformationProvider != null) {
                        response.addFeatures(nodeInformationProvider.getNodeFeatures());
                        response.addIdentities(nodeInformationProvider.getNodeIdentities());
                        response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else {
                        response.setType(IQ.Type.error);
                        response.setError(StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.item_not_found));
                    }
                }
                return response;
            }
        });
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public synchronized void setIdentity(DiscoverInfo.Identity identity) {
        this.identity = (DiscoverInfo.Identity)Objects.requireNonNull((Object)identity, (String)"Identity can not be null");
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public synchronized void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> res = new HashSet<DiscoverInfo.Identity>(this.identities);
        res.add(defaultIdentity);
        return Collections.unmodifiableSet(res);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection connection) {
        ServiceDiscoveryManager sdm = instances.get(connection);
        if (sdm == null) {
            sdm = new ServiceDiscoveryManager(connection);
            instances.put(connection, sdm);
        }
        return sdm;
    }

    public synchronized void addDiscoverInfoTo(DiscoverInfo response) {
        response.addIdentities(this.getIdentities());
        for (String feature : this.getFeatures()) {
            response.addFeature(feature);
        }
        response.addExtension(this.extendedInfo);
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    public synchronized List<String> getFeatures() {
        return new ArrayList<String>(this.features);
    }

    public synchronized void addFeature(String feature) {
        this.features.add(feature);
        this.renewEntityCapsVersion();
    }

    public synchronized void removeFeature(String feature) {
        this.features.remove(feature);
        this.renewEntityCapsVersion();
    }

    public synchronized boolean includesFeature(String feature) {
        return this.features.contains(feature);
    }

    public synchronized void setExtendedInfo(DataForm info) {
        this.extendedInfo = info;
        this.renewEntityCapsVersion();
    }

    public DataForm getExtendedInfo() {
        return this.extendedInfo;
    }

    public List<ExtensionElement> getExtendedInfoAsList() {
        ArrayList<DataForm> res = null;
        if (this.extendedInfo != null) {
            res = new ArrayList<DataForm>(1);
            res.add(this.extendedInfo);
        }
        return res;
    }

    public synchronized void removeExtendedInfo() {
        this.extendedInfo = null;
        this.renewEntityCapsVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverInfo discoverInfo(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (entityID == null) {
            return this.discoverInfo(null, null);
        }
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            for (DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism : discoInfoLookupShortcutMechanisms) {
                DiscoverInfo info = discoInfoLookupShortcutMechanism.getDiscoverInfoByUser(this, entityID);
                if (info == null) continue;
                return info;
            }
        }
        return this.discoverInfo(entityID, null);
    }

    public DiscoverInfo discoverInfo(Jid entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Stanza result = this.connection().createStanzaCollectorAndSend((IQ)disco).nextResultOrThrow();
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(Jid entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Stanza result = this.connection().createStanzaCollectorAndSend((IQ)disco).nextResultOrThrow();
        return (DiscoverItems)result;
    }

    @Deprecated
    public boolean canPublishItems(Jid entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return ServiceDiscoveryManager.canPublishItems(info);
    }

    @Deprecated
    public static boolean canPublishItems(DiscoverInfo info) {
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    @Deprecated
    public void publishItems(Jid entityID, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.publishItems(entityID, null, discoverItems);
    }

    @Deprecated
    public void publishItems(Jid entityID, String node, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        discoverItems.setType(IQ.Type.set);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        this.connection().createStanzaCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
    }

    public boolean serverSupportsFeature(CharSequence feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serverSupportsFeatures(feature);
    }

    public boolean serverSupportsFeatures(CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serverSupportsFeatures(Arrays.asList(features));
    }

    public boolean serverSupportsFeatures(Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures((Jid)this.connection().getXMPPServiceDomain(), features);
    }

    public boolean accountSupportsFeatures(CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.accountSupportsFeatures(Arrays.asList(features));
    }

    public boolean accountSupportsFeatures(Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        EntityBareJid accountJid = this.connection().getUser().asEntityBareJid();
        return this.supportsFeatures((Jid)accountJid, features);
    }

    public boolean supportsFeature(Jid jid, CharSequence feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures(jid, feature);
    }

    public boolean supportsFeatures(Jid jid, CharSequence ... features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.supportsFeatures(jid, Arrays.asList(features));
    }

    public boolean supportsFeatures(Jid jid, Collection<? extends CharSequence> features) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo result = this.discoverInfo(jid);
        for (CharSequence charSequence : features) {
            if (result.containsFeature(charSequence)) continue;
            return false;
        }
        return true;
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.findServicesDiscoverInfo(feature, stopOnFirst, useCache, null);
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(String feature, boolean stopOnFirst, boolean useCache, Map<? super Jid, Exception> encounteredExceptions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DomainBareJid serviceName = this.connection().getXMPPServiceDomain();
        return this.findServicesDiscoverInfo(serviceName, feature, stopOnFirst, useCache, encounteredExceptions);
    }

    public List<DiscoverInfo> findServicesDiscoverInfo(DomainBareJid serviceName, String feature, boolean stopOnFirst, boolean useCache, Map<? super Jid, Exception> encounteredExceptions) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items;
        DiscoverInfo info;
        LinkedList<DiscoverInfo> serviceDiscoInfo;
        if (useCache && (serviceDiscoInfo = (List)this.services.lookup((Object)feature)) != null) {
            return serviceDiscoInfo;
        }
        serviceDiscoInfo = new LinkedList();
        try {
            info = this.discoverInfo((Jid)serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (encounteredExceptions != null) {
                encounteredExceptions.put((Jid)serviceName, (Exception)((Object)e));
            }
            return serviceDiscoInfo;
        }
        if (info.containsFeature(feature)) {
            serviceDiscoInfo.add(info);
            if (stopOnFirst) {
                if (useCache) {
                    this.services.put((Object)feature, serviceDiscoInfo);
                }
                return serviceDiscoInfo;
            }
        }
        try {
            items = this.discoverItems((Jid)serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (encounteredExceptions != null) {
                encounteredExceptions.put((Jid)serviceName, (Exception)((Object)e));
            }
            return serviceDiscoInfo;
        }
        for (DiscoverItems.Item item : items.getItems()) {
            Jid address = item.getEntityID();
            try {
                info = this.discoverInfo(address);
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                if (encounteredExceptions == null) continue;
                encounteredExceptions.put((Jid)address, (Exception)e);
                continue;
            }
            if (!info.containsFeature(feature)) continue;
            serviceDiscoInfo.add(info);
            if (!stopOnFirst) continue;
            break;
        }
        if (useCache) {
            this.services.put((Object)feature, serviceDiscoInfo);
        }
        return serviceDiscoInfo;
    }

    public List<DomainBareJid> findServices(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        List<DiscoverInfo> services = this.findServicesDiscoverInfo(feature, stopOnFirst, useCache);
        ArrayList<DomainBareJid> res = new ArrayList<DomainBareJid>(services.size());
        for (DiscoverInfo info : services) {
            res.add(info.getFrom().asDomainBareJid());
        }
        return res;
    }

    public DomainBareJid findService(String feature, boolean useCache, String category, String type) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        boolean noCategory = StringUtils.isNullOrEmpty((CharSequence)category);
        boolean noType = StringUtils.isNullOrEmpty((CharSequence)type);
        if (noType != noCategory) {
            throw new IllegalArgumentException("Must specify either both, category and type, or none");
        }
        List<DiscoverInfo> services = this.findServicesDiscoverInfo(feature, false, useCache);
        if (services.isEmpty()) {
            return null;
        }
        if (!noCategory && !noType) {
            for (DiscoverInfo info : services) {
                if (!info.hasIdentity(category, type)) continue;
                return info.getFrom().asDomainBareJid();
            }
        }
        return services.get(0).getFrom().asDomainBareJid();
    }

    public DomainBareJid findService(String feature, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.findService(feature, useCache, null, null);
    }

    public boolean addEntityCapabilitiesChangedListener(EntityCapabilitiesChangedListener entityCapabilitiesChangedListener) {
        return this.entityCapabilitiesChangedListeners.add(entityCapabilitiesChangedListener);
    }

    private void renewEntityCapsVersion() {
        for (EntityCapabilitiesChangedListener entityCapabilitiesChangedListener : this.entityCapabilitiesChangedListeners) {
            entityCapabilitiesChangedListener.onEntityCapailitiesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.add(discoInfoLookupShortcutMechanism);
            Collections.sort(discoInfoLookupShortcutMechanisms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDiscoInfoLookupShortcutMechanism(DiscoInfoLookupShortcutMechanism discoInfoLookupShortcutMechanism) {
        List<DiscoInfoLookupShortcutMechanism> list = discoInfoLookupShortcutMechanisms;
        synchronized (list) {
            discoInfoLookupShortcutMechanisms.remove(discoInfoLookupShortcutMechanism);
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection);
            }
        });
    }
}

