/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class PubSubManagerTest {
    public static final DomainBareJid DUMMY_PUBSUB_SERVICE;

    @Test
    public void deleteNodeTest() throws InterruptedException, SmackException, IOException, XMPPException {
        ThreadedDummyConnection con = ThreadedDummyConnection.newInstance();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con, (BareJid)DUMMY_PUBSUB_SERVICE);
        mgr.deleteNode("foo@bar.org");
        PubSub pubSubDeleteRequest = (PubSub)con.getSentPacket();
        Assert.assertEquals((Object)"http://jabber.org/protocol/pubsub#owner", (Object)pubSubDeleteRequest.getChildElementNamespace());
        Assert.assertEquals((Object)"pubsub", (Object)pubSubDeleteRequest.getChildElementName());
    }

    static {
        DomainBareJid pubSubService;
        try {
            pubSubService = JidCreate.domainBareFrom((String)"pubsub.dummy.org");
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        DUMMY_PUBSUB_SERVICE = pubSubService;
    }
}

