/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.util.Verification;
import org.junit.Assert;

public class Protocol {
    public boolean printProtocol = false;
    private final Queue<Stanza> responses = new LinkedList<Stanza>();
    private final List<Verification<?, ?>[]> verificationList = new ArrayList<Verification<?, ?>[]>();
    private final List<Stanza> requests = new ArrayList<Stanza>();
    private final List<Stanza> responsesList = new ArrayList<Stanza>();

    public void addResponse(Stanza response, Verification<?, ?> ... verifications) {
        this.responses.offer(response);
        this.verificationList.add(verifications);
        this.responsesList.add(response);
    }

    public void verifyAll() {
        Assert.assertEquals((long)this.requests.size(), (long)this.responsesList.size());
        if (this.printProtocol) {
            System.out.println("=================== Start ===============\n");
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            Verification<?, ?>[] verifications;
            Stanza request = this.requests.get(i);
            Stanza response = this.responsesList.get(i);
            if (this.printProtocol) {
                System.out.println("------------------- Request -------------\n");
                System.out.println(XmlUtil.prettyFormatXml((CharSequence)request.toXML(null)));
                System.out.println("------------------- Response ------------\n");
                if (response != null) {
                    System.out.println(XmlUtil.prettyFormatXml((CharSequence)response.toXML(null)));
                } else {
                    System.out.println("No response");
                }
            }
            if ((verifications = this.verificationList.get(i)) == null) continue;
            for (Verification<?, ?> verification : verifications) {
                verification.verify(request, response);
            }
        }
        if (this.printProtocol) {
            System.out.println("=================== End =================\n");
        }
    }

    protected Queue<Stanza> getResponses() {
        return this.responses;
    }

    public List<Stanza> getRequests() {
        return this.requests;
    }
}

