/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp;

import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class AMPManager {
    public static synchronized void setServiceEnabled(XMPPConnection connection, boolean enabled) {
        if (AMPManager.isServiceEnabled(connection) == enabled) {
            return;
        }
        if (enabled) {
            ServiceDiscoveryManager.getInstanceFor(connection).addFeature("http://jabber.org/protocol/amp");
        } else {
            ServiceDiscoveryManager.getInstanceFor(connection).removeFeature("http://jabber.org/protocol/amp");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        connection.getXMPPServiceDomain();
        return ServiceDiscoveryManager.getInstanceFor(connection).includesFeature("http://jabber.org/protocol/amp");
    }

    public static boolean isActionSupported(XMPPConnection connection, AMPExtension.Action action) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String featureName = "http://jabber.org/protocol/amp?action=" + action.toString();
        return AMPManager.isFeatureSupportedByServer(connection, featureName);
    }

    public static boolean isConditionSupported(XMPPConnection connection, String conditionName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String featureName = "http://jabber.org/protocol/amp?condition=" + conditionName;
        return AMPManager.isFeatureSupportedByServer(connection, featureName);
    }

    private static boolean isFeatureSupportedByServer(XMPPConnection connection, String featureName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).serverSupportsFeature(featureName);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                AMPManager.setServiceEnabled(connection, true);
            }
        });
    }
}

