/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.blocking.element.BlockedErrorExtension;
import org.junit.Assert;
import org.junit.Test;

public class BlockedErrorExtensionTest {
    private static final String messageWithoutError = "<message from='gardano@erlang-solutions.com' to='griveroa-inaka@erlang-solutions.com/9b7b3fce28742983' type='normal' xml:lang='en' id='5x41G-120'></message>";
    private static final String messageWithError = "<message from='gardano@erlang-solutions.com' to='griveroa-inaka@erlang-solutions.com/9b7b3fce28742983' type='error' xml:lang='en' id='5x41G-121'><error code='406' type='cancel'><not-acceptable xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></message>";
    private static final String messageWithBlockedError = "<message from='gardano@erlang-solutions.com' to='griveroa-inaka@erlang-solutions.com/9b7b3fce28742983' type='error' xml:lang='en' id='5x41G-122'><error code='406' type='cancel'><blocked xmlns='urn:xmpp:blocking:errors'/><not-acceptable xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></message>";

    @Test
    public void checkErrorHasBlockedExtension() throws Exception {
        Message message1 = (Message)PacketParserUtils.parseStanza((String)messageWithoutError);
        Assert.assertFalse((boolean)BlockedErrorExtension.isInside((Message)message1));
        Message message2 = (Message)PacketParserUtils.parseStanza((String)messageWithError);
        Assert.assertFalse((boolean)BlockedErrorExtension.isInside((Message)message2));
        Message message3 = (Message)PacketParserUtils.parseStanza((String)messageWithBlockedError);
        Assert.assertTrue((boolean)BlockedErrorExtension.isInside((Message)message3));
    }
}

