/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.pubsub.ChildrenAssociationPolicy;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NotificationType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.PubSubManagerTest;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public class ConfigureFormTest
extends InitExtensions {
    @Test
    public void checkChildrenAssocPolicy() {
        ConfigureForm form = new ConfigureForm(DataForm.Type.submit);
        form.setChildrenAssociationPolicy(ChildrenAssociationPolicy.owners);
        Assert.assertEquals((Object)ChildrenAssociationPolicy.owners, (Object)form.getChildrenAssociationPolicy());
    }

    @Test
    public void getConfigFormWithInsufficientPrivileges() throws XMPPException, SmackException, IOException, InterruptedException {
        ThreadedDummyConnection con = ThreadedDummyConnection.newInstance();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con, (BareJid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfo info = new DiscoverInfo();
        info.setType(IQ.Type.result);
        info.setFrom((Jid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfo.Identity ident = new DiscoverInfo.Identity("pubsub", null, "leaf");
        info.addIdentity(ident);
        con.addIQReply((IQ)info);
        Node node = mgr.getNode("princely_musings");
        PubSub errorIq = new PubSub();
        errorIq.setType(IQ.Type.error);
        errorIq.setFrom((Jid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        StanzaError.Builder error = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.forbidden);
        errorIq.setError(error);
        con.addIQReply((IQ)errorIq);
        try {
            node.getNodeConfiguration();
            Assert.fail();
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertEquals((Object)StanzaError.Type.AUTH, (Object)e.getXMPPError().getType());
        }
    }

    @Test(expected=SmackException.class)
    public void getConfigFormWithTimeout() throws XMPPException, SmackException, InterruptedException {
        ThreadedDummyConnection con = new ThreadedDummyConnection();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con, (BareJid)PubSubManagerTest.DUMMY_PUBSUB_SERVICE);
        DiscoverInfo info = new DiscoverInfo();
        DiscoverInfo.Identity ident = new DiscoverInfo.Identity("pubsub", null, "leaf");
        info.addIdentity(ident);
        con.addIQReply((IQ)info);
        Node node = mgr.getNode("princely_musings");
        SmackConfiguration.setDefaultReplyTimeout((int)100);
        con.setTimeout();
        node.getNodeConfiguration();
    }

    @Test
    public void checkNotificationType() {
        ConfigureForm form = new ConfigureForm(DataForm.Type.submit);
        form.setNotificationType(NotificationType.normal);
        Assert.assertEquals((Object)NotificationType.normal, (Object)form.getNotificationType());
        form.setNotificationType(NotificationType.headline);
        Assert.assertEquals((Object)NotificationType.headline, (Object)form.getNotificationType());
    }
}

