/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.bytestreams.ibb.CloseListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public class CloseListenerTest
extends InitExtensions {
    private static final Jid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final Jid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;

    @Test
    public void shouldReplyErrorIfSessionIsUnknown() throws Exception {
        XMPPConnection connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)connection);
        CloseListener closeListener = (CloseListener)Whitebox.getInternalState((Object)byteStreamManager, CloseListener.class);
        Close close = new Close("unknownSessionId");
        close.setFrom(initiatorJID);
        close.setTo(targetJID);
        closeListener.handleIQRequest((IQ)close);
        Thread.sleep(200L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)connection)).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)((IQ)argument.getValue()).getError().getCondition());
    }
}

