/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.junit.Assert;
import org.junit.Test;

public class DataPacketExtensionTest
extends InitExtensions {
    private static final Properties outputProperties = new Properties();

    public DataPacketExtensionTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArgument1() {
        new DataPacketExtension(null, 0L, "data");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArgument2() {
        new DataPacketExtension("", 0L, "data");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArgument3() {
        new DataPacketExtension("sessionID", -1L, "data");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArgument4() {
        new DataPacketExtension("sessionID", 70000L, "data");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArgument5() {
        new DataPacketExtension("sessionID", 0L, null);
    }

    @Test
    public void shouldSetAllFieldsCorrectly() {
        DataPacketExtension data = new DataPacketExtension("sessionID", 0L, "data");
        Assert.assertEquals((Object)"sessionID", (Object)data.getSessionID());
        Assert.assertEquals((long)0L, (long)data.getSeq());
        Assert.assertEquals((Object)"data", (Object)data.getData());
    }

    @Test
    public void shouldReturnNullIfDataIsInvalid() {
        DataPacketExtension data = new DataPacketExtension("sessionID", 0L, "BBBB=CCC");
        Assert.assertNull((Object)data.getDecodedData());
        data = new DataPacketExtension("sessionID", 0L, new String(new byte[]{123}, StandardCharsets.UTF_8));
        Assert.assertNull((Object)data.getDecodedData());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String control = XMLBuilder.create((String)"data").a("xmlns", "http://jabber.org/protocol/ibb").a("seq", "0").a("sid", "i781hf64").t("DATA").asString(outputProperties);
        DataPacketExtension data = new DataPacketExtension("i781hf64", 0L, "DATA");
        XmlUnitUtils.assertXmlSimilar((CharSequence)control, (CharSequence)data.toXML().toString());
    }
}

