/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;
import org.mockito.Mockito;

public class DataTest
extends InitExtensions {
    private static final Properties outputProperties = new Properties();

    public DataTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArgument() {
        new Data(null);
    }

    @Test
    public void shouldBeOfIQTypeSET() {
        DataPacketExtension dpe = (DataPacketExtension)Mockito.mock(DataPacketExtension.class);
        Data data = new Data(dpe);
        Assert.assertEquals((Object)IQ.Type.set, (Object)data.getType());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String encodedData = Base64.encode((String)"Test");
        String control = XMLBuilder.create((String)"iq").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "kr91n475").a("type", "set").e("data").a("xmlns", "http://jabber.org/protocol/ibb").a("seq", "0").a("sid", "i781hf64").t(encodedData).asString(outputProperties);
        DataPacketExtension dpe = new DataPacketExtension("i781hf64", 0L, encodedData);
        Data data = new Data(dpe);
        data.setFrom(JidCreate.from((String)"romeo@montague.lit/orchard"));
        data.setTo(JidCreate.from((String)"juliet@capulet.lit/balcony"));
        data.setStanzaId("kr91n475");
        XmlUnitUtils.assertXmlSimilar((CharSequence)control, (CharSequence)data.toXML("jabber:client").toString());
    }
}

