/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.junit.Assert;
import org.junit.Test;

public class Socks5ProxyTest {
    private static final String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();

    @Test
    public void shouldBeAQuasiSingleton() {
        Socks5Proxy proxy1 = Socks5Proxy.getSocks5Proxy();
        Socks5Proxy proxy2 = Socks5Proxy.getSocks5Proxy();
        Assert.assertNotNull((Object)proxy1);
        Assert.assertNotNull((Object)proxy2);
        Assert.assertSame((Object)proxy1, (Object)proxy2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldUseFreePortOnNegativeValues() throws Exception {
        Socks5Proxy proxy = new Socks5Proxy();
        Assert.assertFalse((boolean)proxy.isRunning());
        try (ServerSocket serverSocket = new ServerSocket(0);){
            proxy.setLocalSocks5ProxyPort(-serverSocket.getLocalPort());
            proxy.start();
            Assert.assertTrue((boolean)proxy.isRunning());
            Assert.assertTrue((proxy.getPort() > serverSocket.getLocalPort() ? 1 : 0) != 0);
        }
        finally {
            proxy.stop();
        }
    }

    @Test
    public void shouldPreserveAddressOrderOnInsertions() throws UnknownHostException {
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        LinkedHashSet<InetAddress> addresses = new LinkedHashSet<InetAddress>(proxy.getLocalAddresses());
        for (int i = 1; i <= 3; ++i) {
            addresses.add(InetAddress.getByName(Integer.toString(i)));
        }
        for (InetAddress address : addresses) {
            proxy.addLocalAddress(address);
        }
        List localAddresses = proxy.getLocalAddresses();
        Iterator iterator = addresses.iterator();
        for (int i = 0; i < addresses.size(); ++i) {
            Assert.assertEquals(iterator.next(), localAddresses.get(i));
        }
    }

    @Test
    public void shouldPreserveAddressOrderOnReplace() throws UnknownHostException {
        Socks5Proxy proxy = Socks5Proxy.getSocks5Proxy();
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(proxy.getLocalAddresses());
        addresses.add(InetAddress.getByName("1"));
        addresses.add(InetAddress.getByName("2"));
        addresses.add(InetAddress.getByName("3"));
        proxy.replaceLocalAddresses(addresses);
        List localAddresses = proxy.getLocalAddresses();
        for (int i = 0; i < addresses.size(); ++i) {
            Assert.assertEquals(addresses.get(i), localAddresses.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCloseSocketIfNoSocks5Request() throws Exception {
        Socks5Proxy proxy = new Socks5Proxy();
        proxy.start();
        try (Socket socket = new Socket(loopbackAddress, proxy.getPort());){
            int res;
            OutputStream out = socket.getOutputStream();
            out.write(new byte[]{1, 2, 3});
            try {
                res = socket.getInputStream().read();
            }
            catch (SocketException e) {
                res = -1;
            }
            Assert.assertEquals((long)-1L, (long)res);
        }
        finally {
            proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRespondWithErrorIfNoSupportedAuthenticationMethod() throws Exception {
        Socks5Proxy proxy = new Socks5Proxy();
        proxy.start();
        try (Socket socket = new Socket(loopbackAddress, proxy.getPort());){
            OutputStream out = socket.getOutputStream();
            out.write(new byte[]{5, 1, 2});
            InputStream in = socket.getInputStream();
            Assert.assertEquals((long)5L, (long)((byte)in.read()));
            Assert.assertEquals((long)-1L, (long)((byte)in.read()));
            Assert.assertEquals((long)-1L, (long)in.read());
        }
        finally {
            proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRespondWithErrorIfConnectionIsNotAllowed() throws Exception {
        Socks5Proxy proxy = new Socks5Proxy();
        proxy.start();
        try (Socket socket = new Socket(loopbackAddress, proxy.getPort());){
            OutputStream out = socket.getOutputStream();
            out.write(new byte[]{5, 1, 0});
            InputStream in = socket.getInputStream();
            Assert.assertEquals((long)5L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            out.write(new byte[]{5, 0, 0, 3, 1, -86, 0, 0});
            Assert.assertEquals((long)5L, (long)((byte)in.read()));
            Assert.assertFalse((0 == (byte)in.read() ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            Assert.assertEquals((long)3L, (long)((byte)in.read()));
            Assert.assertEquals((long)1L, (long)((byte)in.read()));
            Assert.assertEquals((long)-86L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            Assert.assertEquals((long)-1L, (long)in.read());
        }
        finally {
            proxy.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSuccessfullyEstablishConnection() throws Exception {
        Socks5Proxy proxy = new Socks5Proxy();
        proxy.start();
        try {
            Assert.assertTrue((boolean)proxy.isRunning());
            String digest = new String(new byte[]{-86}, StandardCharsets.UTF_8);
            proxy.addTransfer(digest);
            Socket socket = new Socket(loopbackAddress, proxy.getPort());
            OutputStream out = socket.getOutputStream();
            out.write(new byte[]{5, 1, 0});
            InputStream in = socket.getInputStream();
            Assert.assertEquals((long)5L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            out.write(new byte[]{5, 0, 0, 3, 1, -86, 0, 0});
            Assert.assertEquals((long)5L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            Assert.assertEquals((long)3L, (long)((byte)in.read()));
            Assert.assertEquals((long)1L, (long)((byte)in.read()));
            Assert.assertEquals((long)-86L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            Assert.assertEquals((long)0L, (long)((byte)in.read()));
            try (Socket remoteSocket = proxy.getSocket(digest);){
                proxy.removeTransfer(digest);
                OutputStream remoteOut = remoteSocket.getOutputStream();
                byte[] data = new byte[]{1, 2, 3, 4, 5};
                remoteOut.write(data);
                remoteOut.flush();
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertEquals((long)data[i], (long)in.read());
                }
            }
            Assert.assertEquals((long)-1L, (long)in.read());
        }
        finally {
            proxy.stop();
        }
    }
}

