/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.forward;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.jivesoftware.smack.test.util.CharSequenceEquals;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.forward.provider.ForwardedProvider;
import org.junit.Assert;
import org.junit.Test;

public class ForwardedTest {
    private static Properties outputProperties = new Properties();

    @Test
    public void forwardedTest() throws Exception {
        String control = XMLBuilder.create((String)"forwarded").a("xmlns", "urn:xmpp:forwarded:0").e("message").a("from", "romeo@montague.com").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Forwarded fwd = (Forwarded)new ForwardedProvider().parse(parser);
        Assert.assertEquals(null, (Object)fwd.getDelayInformation());
        Assert.assertThat((Object)"romeo@montague.com", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)fwd.getForwardedStanza().getFrom()));
        Assert.assertEquals((Object)XmlPullParser.Event.END_ELEMENT, (Object)parser.getEventType());
        Assert.assertEquals((Object)"forwarded", (Object)parser.getName());
    }

    @Test
    public void forwardedWithDelayTest() throws Exception {
        String control = XMLBuilder.create((String)"forwarded").a("xmlns", "urn:xmpp:forwarded:0").e("message").a("from", "romeo@montague.com").up().e("delay").ns("urn:xmpp:delay").a("stamp", "2010-07-10T23:08:25Z").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Forwarded fwd = (Forwarded)new ForwardedProvider().parse(parser);
        DelayInformation delay = fwd.getDelayInformation();
        Assert.assertNotNull((Object)delay);
        Assert.assertThat((Object)"romeo@montague.com", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)fwd.getForwardedStanza().getFrom()));
        Assert.assertEquals((Object)XmlPullParser.Event.END_ELEMENT, (Object)parser.getEventType());
        Assert.assertEquals((Object)"forwarded", (Object)parser.getName());
    }

    @Test(expected=Exception.class)
    public void forwardedEmptyTest() throws Exception {
        String control = XMLBuilder.create((String)"forwarded").a("xmlns", "urn:xmpp:forwarded:0").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        new ForwardedProvider().parse(parser);
    }

    static {
        outputProperties.put("omit-xml-declaration", "yes");
    }
}

