/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.packet;

import java.net.URI;
import java.util.Calendar;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.geoloc.packet.GeoLocation;
import org.jivesoftware.smackx.time.packet.Time;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.util.XmppDateTime;

public class GeoLocationTest
extends InitExtensions {
    @Test
    public void negativeTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT-830"));
        Time time = new Time(calendar);
        GeoLocation geoLocation = new GeoLocation.Builder().setTzo(time.getTzo()).build();
        Assert.assertEquals((Object)"-8:30", (Object)geoLocation.getTzo());
    }

    @Test
    public void positiveTimezonTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+530"));
        Time time = new Time(calendar);
        GeoLocation geoLocation = new GeoLocation.Builder().setTzo(time.getTzo()).build();
        Assert.assertEquals((Object)"+5:30", (Object)geoLocation.getTzo());
    }

    @Test
    public void accuracyTest() {
        GeoLocation geoLocation = new GeoLocation.Builder().setAccuracy(Double.valueOf(1.34)).build();
        Assert.assertEquals((Object)1.34, (Object)geoLocation.getAccuracy());
    }

    @Test
    public void altAccuracyTest() {
        GeoLocation geoLocation = new GeoLocation.Builder().setAltAccuracy(Double.valueOf(1.52)).build();
        Assert.assertEquals((Object)1.52, (Object)geoLocation.getAltAccuracy());
    }

    @Test
    public void toXMLMethodTest() throws Exception {
        String geoLocationMessageString = "<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>";
        Message messageWithGeoLocation = (Message)PacketParserUtils.parseStanza((String)"<message from='portia@merchantofvenice.lit' to='bassanio@merchantofvenice.lit'><geoloc xmlns='http://jabber.org/protocol/geoloc'><accuracy>23</accuracy><alt>1000</alt><altaccuracy>10</altaccuracy><area>Delhi</area><bearing>10</bearing><building>Small Building</building><country>India</country><countrycode>IN</countrycode><description>My Description</description><error>90</error><floor>top</floor><lat>25.098345</lat><locality>awesome</locality><lon>77.992034</lon><postalcode>110085</postalcode><region>North</region><room>small</room><speed>250.0</speed><street>Wall Street</street><text>Unit Testing GeoLocation</text><timestamp>2004-02-19</timestamp><tzo>+5:30</tzo><uri>http://xmpp.org</uri></geoloc></message>");
        Assert.assertNotNull((Object)messageWithGeoLocation);
        GeoLocation geoLocation = (GeoLocation)messageWithGeoLocation.getExtension("geoloc", "http://jabber.org/protocol/geoloc");
        Assert.assertNotNull((Object)geoLocation);
        Assert.assertNotNull((Object)geoLocation.toXML());
        GeoLocation constructedGeoLocation = GeoLocation.builder().setAccuracy(Double.valueOf(23.0)).setAlt(Double.valueOf(1000.0)).setAltAccuracy(Double.valueOf(10.0)).setArea("Delhi").setBearing(Double.valueOf(10.0)).setBuilding("Small Building").setCountry("India").setCountryCode("IN").setDescription("My Description").setError(Double.valueOf(90.0)).setFloor("top").setLat(Double.valueOf(25.098345)).setLocality("awesome").setLon(Double.valueOf(77.992034)).setPostalcode("110085").setRegion("North").setRoom("small").setSpeed(Double.valueOf(250.0)).setStreet("Wall Street").setText("Unit Testing GeoLocation").setTimestamp(XmppDateTime.parseDate((String)"2004-02-19")).setTzo("+5:30").setUri(new URI("http://xmpp.org")).build();
        Assert.assertEquals((Object)constructedGeoLocation.toXML().toString(), (Object)geoLocation.toXML().toString());
    }
}

