/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.junit.Test;

public class JingleContentTest
extends SmackTestSuite {
    @Test(expected=IllegalArgumentException.class)
    public void emptyBuilderThrowsTest() {
        JingleContent.Builder builder = JingleContent.getBuilder();
        builder.build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void onlyCreatorBuilderThrowsTest() {
        JingleContent.Builder builder = JingleContent.getBuilder();
        builder.setCreator(JingleContent.Creator.initiator);
        builder.build();
    }

    @Test
    public void parserTest() throws Exception {
        JingleContent.Builder builder = JingleContent.getBuilder();
        builder.setCreator(JingleContent.Creator.initiator);
        builder.setName("A name");
        JingleContent content = builder.build();
        TestCase.assertNotNull((Object)content);
        TestCase.assertNull((Object)content.getDescription());
        TestCase.assertEquals((Object)JingleContent.Creator.initiator, (Object)content.getCreator());
        TestCase.assertEquals((String)"A name", (String)content.getName());
        builder.setSenders(JingleContent.Senders.both);
        content = builder.build();
        TestCase.assertEquals((Object)JingleContent.Senders.both, (Object)content.getSenders());
        builder.setDisposition("session");
        JingleContent content1 = builder.build();
        TestCase.assertEquals((String)"session", (String)content1.getDisposition());
        TestCase.assertNotSame((Object)content.toXML().toString(), (Object)content1.toXML().toString());
        TestCase.assertEquals((String)content1.toXML().toString(), (String)builder.build().toXML().toString());
        String xml = "<content creator='initiator' disposition='session' name='A name' senders='both'></content>";
        TestCase.assertEquals((String)xml, (String)content1.toXML().toString());
    }
}

