/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smackx.jingle.element.JingleError;
import org.jivesoftware.smackx.jingle.provider.JingleErrorProvider;
import org.junit.Test;

public class JingleErrorTest
extends SmackTestSuite {
    @Test
    public void tieBreakTest() throws Exception {
        String xml = "<tie-break xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        TestCase.assertEquals((String)xml, (String)error.toXML().toString());
    }

    @Test
    public void unknownSessionTest() throws Exception {
        String xml = "<unknown-session xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        TestCase.assertEquals((String)xml, (String)error.toXML().toString());
    }

    @Test
    public void unsupportedInfoTest() throws Exception {
        String xml = "<unsupported-info xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        TestCase.assertEquals((String)xml, (String)error.toXML().toString());
    }

    @Test
    public void outOfOrderTest() throws Exception {
        String xml = "<out-of-order xmlns='urn:xmpp:jingle:errors:1'/>";
        JingleError error = (JingleError)new JingleErrorProvider().parse(TestUtils.getParser((String)xml));
        TestCase.assertEquals((String)xml, (String)error.toXML().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalArgumentTest() {
        JingleError.fromString((String)"inexistent-error");
    }
}

