/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider.JingleS5BTransportProvider;
import org.junit.Test;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class JingleS5BTransportTest
extends SmackTestSuite {
    @Test
    public void candidatesProviderTest() throws Exception {
        String xml = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' dstaddr='972b7bf47291ca609517f67f86b5081086052dad' mode='tcp' sid='vj3hs98y'><candidate cid='hft54dqy' host='192.168.4.1' jid='romeo@montague.lit/orchard' port='5086' priority='8257636' type='direct'/><candidate cid='hutr46fe' host='24.24.24.1' jid='romeo@montague.lit/orchard' port='5087' priority='8258636' type='direct'/><candidate cid='xmdh4b7i' host='123.456.7.8' jid='streamer.shakespeare.lit' port='7625' priority='7878787' type='proxy'/></transport>";
        JingleS5BTransport transport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)xml));
        TestCase.assertEquals((String)"972b7bf47291ca609517f67f86b5081086052dad", (String)transport.getDestinationAddress());
        TestCase.assertEquals((String)"vj3hs98y", (String)transport.getStreamId());
        TestCase.assertEquals((Object)Bytestream.Mode.tcp, (Object)transport.getMode());
        TestCase.assertEquals((int)3, (int)transport.getCandidates().size());
        TestCase.assertTrue((boolean)transport.hasCandidate("hft54dqy"));
        TestCase.assertFalse((boolean)transport.hasCandidate("invalidId"));
        JingleS5BTransportCandidate candidate1 = (JingleS5BTransportCandidate)transport.getCandidates().get(0);
        TestCase.assertEquals((Object)candidate1, (Object)transport.getCandidate("hft54dqy"));
        TestCase.assertNotNull((Object)candidate1.getStreamHost());
        TestCase.assertEquals((int)JingleS5BTransportCandidate.Type.direct.getWeight(), (int)candidate1.getType().getWeight());
        TestCase.assertEquals((String)"hft54dqy", (String)candidate1.getCandidateId());
        TestCase.assertEquals((String)"192.168.4.1", (String)candidate1.getHost().toString());
        TestCase.assertEquals((Object)JidCreate.from((String)"romeo@montague.lit/orchard"), (Object)candidate1.getJid());
        TestCase.assertEquals((int)5086, (int)candidate1.getPort());
        TestCase.assertEquals((int)8257636, (int)candidate1.getPriority());
        TestCase.assertEquals((Object)JingleS5BTransportCandidate.Type.direct, (Object)candidate1.getType());
        JingleS5BTransportCandidate candidate2 = (JingleS5BTransportCandidate)transport.getCandidates().get(1);
        TestCase.assertEquals((String)"hutr46fe", (String)candidate2.getCandidateId());
        TestCase.assertEquals((String)"24.24.24.1", (String)candidate2.getHost().toString());
        TestCase.assertEquals((Object)JidCreate.from((String)"romeo@montague.lit/orchard"), (Object)candidate2.getJid());
        TestCase.assertEquals((int)5087, (int)candidate2.getPort());
        TestCase.assertEquals((int)8258636, (int)candidate2.getPriority());
        TestCase.assertEquals((Object)JingleS5BTransportCandidate.Type.direct, (Object)candidate2.getType());
        JingleS5BTransportCandidate candidate3 = (JingleS5BTransportCandidate)transport.getCandidates().get(2);
        TestCase.assertEquals((String)"xmdh4b7i", (String)candidate3.getCandidateId());
        TestCase.assertEquals((String)"123.456.7.8", (String)candidate3.getHost().toString());
        TestCase.assertEquals((Object)JidCreate.domainBareFrom((String)"streamer.shakespeare.lit"), (Object)candidate3.getJid());
        TestCase.assertEquals((int)7625, (int)candidate3.getPort());
        TestCase.assertEquals((int)0x783883, (int)candidate3.getPriority());
        TestCase.assertEquals((Object)JingleS5BTransportCandidate.Type.proxy, (Object)candidate3.getType());
        TestCase.assertEquals((String)xml, (String)transport.toXML().toString());
    }

    @Test
    public void infoProviderTest() throws Exception {
        String candidateError = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><candidate-error/></transport>";
        JingleS5BTransport candidateErrorTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)candidateError));
        TestCase.assertNull((Object)candidateErrorTransport.getDestinationAddress());
        TestCase.assertNotNull((Object)candidateErrorTransport.getInfo());
        TestCase.assertEquals((String)"vj3hs98y", (String)candidateErrorTransport.getStreamId());
        TestCase.assertEquals((Object)JingleS5BTransportInfo.CandidateError.INSTANCE, (Object)candidateErrorTransport.getInfo());
        TestCase.assertEquals((String)candidateError, (String)candidateErrorTransport.toXML().toString());
        String proxyError = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><proxy-error/></transport>";
        JingleS5BTransport proxyErrorTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)proxyError));
        TestCase.assertNull((Object)proxyErrorTransport.getDestinationAddress());
        TestCase.assertNotNull((Object)proxyErrorTransport.getInfo());
        TestCase.assertNotNull((Object)candidateErrorTransport.getInfo());
        TestCase.assertEquals((String)"vj3hs98y", (String)proxyErrorTransport.getStreamId());
        TestCase.assertEquals((Object)JingleS5BTransportInfo.ProxyError.INSTANCE, (Object)proxyErrorTransport.getInfo());
        TestCase.assertEquals((String)proxyError, (String)proxyErrorTransport.toXML().toString());
        String candidateUsed = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><candidate-used cid='hr65dqyd'/></transport>";
        JingleS5BTransport candidateUsedTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)candidateUsed));
        TestCase.assertNotNull((Object)candidateUsedTransport.getInfo());
        TestCase.assertEquals((Object)new JingleS5BTransportInfo.CandidateUsed("hr65dqyd"), (Object)candidateUsedTransport.getInfo());
        TestCase.assertEquals((String)"hr65dqyd", (String)((JingleS5BTransportInfo.CandidateUsed)candidateUsedTransport.getInfo()).getCandidateId());
        TestCase.assertEquals((String)candidateUsed, (String)candidateUsedTransport.toXML().toString());
        String candidateActivated = "<transport xmlns='urn:xmpp:jingle:transports:s5b:1' sid='vj3hs98y'><candidate-activated cid='hr65dqyd'/></transport>";
        JingleS5BTransport candidateActivatedTransport = (JingleS5BTransport)new JingleS5BTransportProvider().parse(TestUtils.getParser((String)candidateActivated));
        TestCase.assertNotNull((Object)candidateActivatedTransport.getInfo());
        TestCase.assertNotNull((Object)candidateErrorTransport.getInfo());
        TestCase.assertEquals((Object)new JingleS5BTransportInfo.CandidateActivated("hr65dqyd"), (Object)candidateActivatedTransport.getInfo());
        TestCase.assertEquals((String)"hr65dqyd", (String)((JingleS5BTransportInfo.CandidateActivated)candidateActivatedTransport.getInfo()).getCandidateId());
        TestCase.assertEquals((String)candidateActivated, (String)candidateActivatedTransport.toXML().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void candidateBuilderInvalidPortTest() {
        JingleS5BTransportCandidate.getBuilder().setPort(-5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void candidateBuilderInvalidPriorityTest() {
        JingleS5BTransportCandidate.getBuilder().setPriority(-1000);
    }

    @Test(expected=IllegalArgumentException.class)
    public void transportCandidateIllegalPriorityTest() throws XmppStringprepException, UnknownHostException {
        FullJid jid = JidCreate.fullFrom((String)"test@test.test/test");
        JingleS5BTransportCandidate candidate = new JingleS5BTransportCandidate("cid", "localhost", (Jid)jid, 5555, -30, JingleS5BTransportCandidate.Type.proxy);
    }

    @Test(expected=IllegalArgumentException.class)
    public void transportCandidateIllegalPortTest() throws XmppStringprepException, UnknownHostException {
        FullJid jid = JidCreate.fullFrom((String)"test@test.test/test");
        JingleS5BTransportCandidate candidate = new JingleS5BTransportCandidate("cid", "host", (Jid)jid, -5555, 30, JingleS5BTransportCandidate.Type.proxy);
    }

    @Test
    public void candidateFromStreamHostTest() throws XmppStringprepException, UnknownHostException {
        FullJid jid = JidCreate.fullFrom((String)"test@test.test/test");
        String host = "localhost";
        int port = 1234;
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)jid, host, port);
        JingleS5BTransportCandidate candidate = new JingleS5BTransportCandidate(streamHost, 2000, JingleS5BTransportCandidate.Type.direct);
        TestCase.assertEquals((int)2000, (int)candidate.getPriority());
        TestCase.assertEquals((Object)jid, (Object)candidate.getJid());
        TestCase.assertEquals((String)host, (String)candidate.getHost().toString());
        TestCase.assertEquals((int)port, (int)candidate.getPort());
        TestCase.assertEquals((String)streamHost.toXML().toString(), (String)candidate.getStreamHost().toXML().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void typeFromIllegalStringTest() {
        JingleS5BTransportCandidate.Type.fromString((String)"illegal-type");
    }
}

