/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mediaelement.provider;

import java.io.IOException;
import java.util.List;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.mediaelement.provider.MediaElementProvider;
import org.junit.Assert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class MediaElementProviderTest {
    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void simpleMediaElementTest(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<media xmlns='urn:xmpp:media-element' height='80' width='290'><uri type='audio/x-wav'>http://victim.example.com/challenges/speech.wav?F3A6292C</uri></media>";
        MediaElement mediaElement = (MediaElement)SmackTestUtil.parse((CharSequence)"<media xmlns='urn:xmpp:media-element' height='80' width='290'><uri type='audio/x-wav'>http://victim.example.com/challenges/speech.wav?F3A6292C</uri></media>", MediaElementProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        Assert.assertEquals((long)80L, (long)mediaElement.getHeight().intValue());
        Assert.assertEquals((long)290L, (long)mediaElement.getWidth().intValue());
        List uris = mediaElement.getUris();
        Assert.assertEquals((long)1L, (long)uris.size());
        MediaElement.Uri uri = (MediaElement.Uri)uris.get(0);
        Assert.assertEquals((Object)"audio/x-wav", (Object)uri.getType());
        Assert.assertEquals((Object)"http://victim.example.com/challenges/speech.wav?F3A6292C", (Object)uri.getUri().toString());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void parseMediaElementTest(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        String xml = "<media xmlns='urn:xmpp:media-element'><uri type='audio/x-wav'>http://victim.example.com/challenges/speech.wav?F3A6292C</uri><uri type='audio/ogg; codecs=speex'>cid:sha1+a15a505e360702b79c75a5f67773072ed392f52a@bob.xmpp.org</uri><uri type='audio/mpeg'>http://victim.example.com/challenges/speech.mp3?F3A6292C</uri></media>";
        MediaElement mediaElement = (MediaElement)SmackTestUtil.parse((CharSequence)"<media xmlns='urn:xmpp:media-element'><uri type='audio/x-wav'>http://victim.example.com/challenges/speech.wav?F3A6292C</uri><uri type='audio/ogg; codecs=speex'>cid:sha1+a15a505e360702b79c75a5f67773072ed392f52a@bob.xmpp.org</uri><uri type='audio/mpeg'>http://victim.example.com/challenges/speech.mp3?F3A6292C</uri></media>", MediaElementProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        List uris = mediaElement.getUris();
        Assert.assertEquals((long)3L, (long)uris.size());
    }
}

