/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.mood.provider.MoodProvider;
import org.junit.Test;

public class MoodElementTest
extends SmackTestSuite {
    @Test
    public void toXmlTest() throws Exception {
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'><happy/><text>Yay, the mood spec has been approved!</text></mood>";
        MoodElement moodElement = new MoodElement(new MoodElement.MoodSubjectElement(Mood.happy, null), "Yay, the mood spec has been approved!");
        XmlUnitUtils.assertXmlSimilar((CharSequence)xml, (CharSequence)moodElement.toXML().toString());
        TestCase.assertFalse((boolean)moodElement.hasConcretisation());
        TestCase.assertEquals((Object)Mood.happy, (Object)moodElement.getMood());
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodElement parsed = (MoodElement)MoodProvider.INSTANCE.parse(parser);
        TestCase.assertEquals((String)xml, (String)parsed.toXML().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalArgumentsTest() {
        new MoodElement(null, "Text alone is not allowed.");
    }

    @Test
    public void emptyMoodTest() throws Exception {
        MoodElement empty = new MoodElement(null, null);
        TestCase.assertNull((Object)empty.getText());
        TestCase.assertNull((Object)empty.getMood());
        TestCase.assertNull((Object)empty.getMoodConcretisation());
        TestCase.assertFalse((boolean)empty.hasText());
        TestCase.assertFalse((boolean)empty.hasConcretisation());
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'/>";
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodElement emptyParsed = (MoodElement)MoodProvider.INSTANCE.parse(parser);
        TestCase.assertEquals((String)empty.toXML().toString(), (String)emptyParsed.toXML().toString());
    }

    @Test(expected=XmlPullParserException.class)
    public void unknownMoodValueExceptionTest() throws Exception {
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'><unknown/></mood>";
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodProvider.INSTANCE.parse(parser);
    }
}

