/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.Assert;
import org.junit.Test;

public class RoomInfoTest {
    @Test
    public void validateRoomWithEmptyForm() {
        DataForm dataForm = new DataForm(DataForm.Type.result);
        DiscoverInfo discoInfo = new DiscoverInfo();
        discoInfo.addExtension((ExtensionElement)dataForm);
        RoomInfo roomInfo = new RoomInfo(discoInfo);
        Assert.assertTrue((boolean)roomInfo.getDescription().isEmpty());
        Assert.assertTrue((boolean)roomInfo.getSubject().isEmpty());
        Assert.assertEquals((long)-1L, (long)roomInfo.getOccupantsCount());
    }

    @Test
    public void validateRoomWithForm() {
        DataForm dataForm = new DataForm(DataForm.Type.result);
        FormField.Builder desc = FormField.builder((String)"muc#roominfo_description");
        desc.addValue((CharSequence)"The place for all good witches!");
        dataForm.addField(desc.build());
        FormField.Builder subject = FormField.builder((String)"muc#roominfo_subject");
        subject.addValue((CharSequence)"Spells");
        dataForm.addField(subject.build());
        FormField.Builder occupants = FormField.builder((String)"muc#roominfo_occupants");
        occupants.addValue((CharSequence)"3");
        dataForm.addField(occupants.build());
        DiscoverInfo discoInfo = new DiscoverInfo();
        discoInfo.addExtension((ExtensionElement)dataForm);
        RoomInfo roomInfo = new RoomInfo(discoInfo);
        Assert.assertEquals((Object)"The place for all good witches!", (Object)roomInfo.getDescription());
        Assert.assertEquals((Object)"Spells", (Object)roomInfo.getSubject());
        Assert.assertEquals((long)3L, (long)roomInfo.getOccupantsCount());
    }
}

