/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.SimplePayload;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemValidationTest
extends InitExtensions {
    private ThreadedDummyConnection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = new ThreadedDummyConnection();
        this.connection.connect();
        this.connection.login();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void verifyBasicItem() throws Exception {
        Item simpleItem = new Item();
        String simpleCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' />";
        XmlUnitUtils.assertXmlSimilar((CharSequence)simpleCtrl, (CharSequence)simpleItem.toXML().toString());
        Item idItem = new Item("uniqueid");
        String idCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='uniqueid'/>";
        XmlUnitUtils.assertXmlSimilar((CharSequence)idCtrl, (CharSequence)idItem.toXML().toString());
        Item itemWithNodeId = new Item("testId", "testNode");
        String nodeIdCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='testId' node='testNode' />";
        XmlUnitUtils.assertXmlSimilar((CharSequence)nodeIdCtrl, (CharSequence)itemWithNodeId.toXML().toString());
    }

    @Test
    public void verifyPayloadItem() throws Exception {
        SimplePayload payload = new SimplePayload("<data xmlns='https://example.org'>This is the payload</data>");
        PayloadItem simpleItem = new PayloadItem((ExtensionElement)payload);
        String simpleCtrl = "<item xmlns='http://jabber.org/protocol/pubsub'>" + payload.toXML() + "</item>";
        XmlUnitUtils.assertXmlSimilar((CharSequence)simpleCtrl, (CharSequence)simpleItem.toXML().toString());
        PayloadItem idItem = new PayloadItem("uniqueid", (ExtensionElement)payload);
        String idCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='uniqueid'>" + payload.toXML() + "</item>";
        XmlUnitUtils.assertXmlSimilar((CharSequence)idCtrl, (CharSequence)idItem.toXML().toString());
        PayloadItem itemWithNodeId = new PayloadItem("testId", "testNode", (ExtensionElement)payload);
        String nodeIdCtrl = "<item xmlns='http://jabber.org/protocol/pubsub' id='testId' node='testNode'>" + payload.toXML() + "</item>";
        XmlUnitUtils.assertXmlSimilar((CharSequence)nodeIdCtrl, (CharSequence)itemWithNodeId.toXML().toString());
    }

    @Test
    public void parseBasicItem() throws Exception {
        XmlPullParser parser = PacketParserUtils.getParserFor((String)"<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' /></items></event></message>");
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        Assert.assertTrue((boolean)(eventExt instanceof EventElement));
        EventElement event = (EventElement)eventExt;
        Assert.assertEquals((Object)EventElementType.items, (Object)event.getEventType());
        Assert.assertEquals((long)1L, (long)event.getExtensions().size());
        Assert.assertTrue((boolean)(event.getExtensions().get(0) instanceof ItemsExtension));
        Assert.assertEquals((long)1L, (long)((ItemsExtension)event.getExtensions().get((int)0)).items.size());
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof Item));
        Assert.assertEquals((Object)"testid1", (Object)((Item)itemExt).getId());
    }

    @Test
    public void parseSimplePayloadItem() throws Exception {
        String itemContent = "<foo xmlns='smack:test'>Some text</foo>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item></items></event></message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        EventElement event = (EventElement)eventExt;
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assert.assertEquals((Object)"testid1", (Object)item.getId());
        Assert.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        SimplePayload payload = (SimplePayload)item.getPayload();
        Assert.assertEquals((Object)"foo", (Object)payload.getElementName());
        Assert.assertEquals((Object)"smack:test", (Object)payload.getNamespace());
        XmlUnitUtils.assertXmlSimilar((CharSequence)itemContent, (CharSequence)payload.toXML().toString());
    }

    @Test
    public void parseComplexItem() throws Exception {
        String itemContent = "<entry xmlns='http://www.w3.org/2005/Atom'><title>Soliloquy</title><summary>To be, or not to be: that is the question:Whether 'tis nobler in the mind to sufferThe slings and arrows of outrageous fortune,Or to take arms against a sea of troubles,And by opposing end them?</summary><link rel='alternate' type='text/html' href='http://denmark.lit/2003/12/13/atom03'/><id>tag:denmark.lit,2003:entry-32397</id><published>2003-12-13T18:30:02Z</published><updated>2003-12-13T18:30:02Z</updated></entry>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item></items></event></message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        EventElement event = (EventElement)eventExt;
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assert.assertEquals((Object)"testid1", (Object)item.getId());
        Assert.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        SimplePayload payload = (SimplePayload)item.getPayload();
        Assert.assertEquals((Object)"entry", (Object)payload.getElementName());
        Assert.assertEquals((Object)"http://www.w3.org/2005/Atom", (Object)payload.getNamespace());
        XmlUnitUtils.assertXmlSimilar((CharSequence)itemContent, (CharSequence)payload.toXML().toString());
    }

    @Test
    public void parseEmptyTag() throws Exception {
        String itemContent = "<foo xmlns='smack:test'><bar/></foo>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item></items></event></message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.event.getXmlns());
        Assert.assertTrue((boolean)(eventExt instanceof EventElement));
        EventElement event = (EventElement)eventExt;
        Assert.assertEquals((Object)EventElementType.items, (Object)event.getEventType());
        Assert.assertEquals((long)1L, (long)event.getExtensions().size());
        Assert.assertTrue((boolean)(event.getExtensions().get(0) instanceof ItemsExtension));
        Assert.assertEquals((long)1L, (long)((ItemsExtension)event.getExtensions().get((int)0)).items.size());
        NamedElement itemExt = (NamedElement)((ItemsExtension)event.getExtensions().get((int)0)).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assert.assertEquals((Object)"testid1", (Object)item.getId());
        Assert.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        XmlUnitUtils.assertXmlSimilar((CharSequence)itemContent, (CharSequence)item.getPayload().toXML().toString());
    }
}

