/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;

public class PubSubNodeTest
extends SmackTestSuite {
    @Test
    public void modifySubscriptionsAsOwnerTest() throws InterruptedException, SmackException, IOException, XMPPException, Exception {
        ThreadedDummyConnection con = ThreadedDummyConnection.newInstance();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con, (BareJid)JidTestUtil.PUBSUB_EXAMPLE_ORG);
        LeafNode testNode = new LeafNode(mgr, "princely_musings");
        List<Subscription> ChangeSubs = Arrays.asList(new Subscription(JidCreate.from((String)"romeo@montague.org"), Subscription.State.subscribed), new Subscription(JidCreate.from((String)"juliet@capulet.org"), Subscription.State.none));
        testNode.modifySubscriptionsAsOwner(ChangeSubs);
        PubSub request = (PubSub)con.getSentPacket();
        Assert.assertEquals((Object)"http://jabber.org/protocol/pubsub#owner", (Object)request.getChildElementNamespace());
        Assert.assertEquals((Object)"pubsub", (Object)request.getChildElementName());
        XmlPullParser parser = TestUtils.getIQParser((String)request.toXML().toString());
        PubSub pubsubResult = (PubSub)PacketParserUtils.parseIQ((XmlPullParser)parser);
        SubscriptionsExtension subElem = (SubscriptionsExtension)pubsubResult.getExtension(PubSubElementType.SUBSCRIPTIONS_OWNER);
        List subscriptions = subElem.getSubscriptions();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        Subscription sub1 = (Subscription)subscriptions.get(0);
        Assert.assertEquals((Object)"romeo@montague.org", (Object)sub1.getJid().toString());
        Assert.assertEquals((Object)Subscription.State.subscribed, (Object)sub1.getState());
        Subscription sub2 = (Subscription)subscriptions.get(1);
        Assert.assertEquals((Object)"juliet@capulet.org", (Object)sub2.getJid().toString());
        Assert.assertEquals((Object)Subscription.State.none, (Object)sub2.getState());
    }

    @Test
    public void getAffiliationsAsOwnerTest() throws InterruptedException, SmackException, IOException, XMPPException, Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection(protocol, JidTestUtil.FULL_JID_1_RESOURCE_1);
        PubSubManager mgr = new PubSubManager(connection, (BareJid)JidTestUtil.PUBSUB_EXAMPLE_ORG);
        LeafNode testNode = new LeafNode(mgr, "princely_musings");
        List<Affiliation> affiliations = Arrays.asList(new Affiliation((BareJid)JidTestUtil.BARE_JID_1, Affiliation.Type.member), new Affiliation((BareJid)JidTestUtil.BARE_JID_2, Affiliation.Type.publisher));
        AffiliationsExtension affiliationsExtension = new AffiliationsExtension(Affiliation.AffiliationNamespace.owner, affiliations);
        PubSub response = new PubSub((Jid)JidTestUtil.PUBSUB_EXAMPLE_ORG, IQ.Type.result, PubSubNamespace.owner);
        response.addExtension((ExtensionElement)affiliationsExtension);
        protocol.addResponse((Stanza)response, new Verification[0]);
        List returnedAffiliations = testNode.getAffiliationsAsOwner();
        PubSub request = (PubSub)protocol.getRequests().get(0);
        Assert.assertEquals((Object)"http://jabber.org/protocol/pubsub#owner", (Object)request.getChildElementNamespace());
        Assert.assertEquals((Object)"pubsub", (Object)request.getChildElementName());
        Affiliation affiliationOne = (Affiliation)returnedAffiliations.get(0);
        Assert.assertEquals((Object)affiliationOne.getJid(), (Object)JidTestUtil.BARE_JID_1);
        Assert.assertEquals((Object)affiliationOne.getAffiliation(), (Object)Affiliation.Type.member);
        Affiliation affiliationTwo = (Affiliation)returnedAffiliations.get(1);
        Assert.assertEquals((Object)affiliationTwo.getJid(), (Object)JidTestUtil.BARE_JID_2);
        Assert.assertEquals((Object)affiliationTwo.getAffiliation(), (Object)Affiliation.Type.publisher);
    }
}

