/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatalayout.packet;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jivesoftware.smackx.xdatalayout.packet.DataLayout;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;
import org.junit.Assert;
import org.junit.Test;

public class DataLayoutTest {
    private static final String TEST_OUTPUT_2 = "<page xmlns='http://jabber.org/protocol/xdata-layout' label='Label'><fieldref var='testField1'/><section label='section Label'><text>SectionText</text></section><text>PageText</text></page>";
    private static final String TEST_OUTPUT_SPECIAL = "<page xmlns='http://jabber.org/protocol/xdata-layout' label='Label - &amp; \u00e9 \u00e1 '><fieldref var='testField1'/><section label='section Label - &amp; \u00e9 \u00e1 '><text>SectionText - &amp; \u00e9 \u00e1 </text></section><text>PageText - &amp; \u00e9 \u00e1 </text><section label='&lt;html>Number of Persons by&lt;br/> Nationality and Status&lt;/html>'><reportedref/></section><text>&lt;html&gt;&lt;font color=&apos;red&apos;&gt;&lt;em&gt;DO NOT DELAY&lt;/em&gt;&lt;/font&gt;&lt;br/&gt;supply further information&lt;/html&gt;</text></page>";
    private static final String TEST_INPUT_1 = "xdata-layout-sample.xml";

    @Test
    public void testLayout() throws Exception {
        DataLayout layout = new DataLayout("Label");
        DataLayout.Fieldref reffield = new DataLayout.Fieldref("testField1");
        layout.getPageLayout().add(reffield);
        DataLayout.Section section = new DataLayout.Section("section Label");
        section.getSectionLayout().add(new DataLayout.Text("SectionText"));
        layout.getPageLayout().add(section);
        layout.getPageLayout().add(new DataLayout.Text("PageText"));
        Assert.assertNotNull((Object)layout.toXML());
        String output = layout.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_2, (Object)output);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)output);
        layout = DataLayoutProvider.parse((XmlPullParser)parser);
        Assert.assertEquals((long)3L, (long)layout.getPageLayout().size());
        Assert.assertEquals((Object)"Label", (Object)layout.getLabel());
        Assert.assertNotNull((Object)layout.toXML());
        output = layout.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_2, (Object)output);
    }

    @Test
    public void testLayoutSpecialCharacters() throws XmlPullParserException, IOException {
        DataLayout layout = new DataLayout("Label - & \u00e9 \u00e1 ");
        DataLayout.Fieldref reffield = new DataLayout.Fieldref("testField1");
        layout.getPageLayout().add(reffield);
        DataLayout.Section section = new DataLayout.Section("section Label - & \u00e9 \u00e1 ");
        section.getSectionLayout().add(new DataLayout.Text("SectionText - & \u00e9 \u00e1 "));
        layout.getPageLayout().add(section);
        layout.getPageLayout().add(new DataLayout.Text("PageText - & \u00e9 \u00e1 "));
        section = new DataLayout.Section("<html>Number of Persons by<br/> Nationality and Status</html>");
        section.getSectionLayout().add(new DataLayout.Reportedref());
        layout.getPageLayout().add(section);
        layout.getPageLayout().add(new DataLayout.Text("<html><font color='red'><em>DO NOT DELAY</em></font><br/>supply further information</html>"));
        Assert.assertNotNull((Object)layout.toXML());
        String output = layout.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_SPECIAL, (Object)output);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)output);
        layout = DataLayoutProvider.parse((XmlPullParser)parser);
        Assert.assertEquals((long)5L, (long)layout.getPageLayout().size());
        Assert.assertEquals((Object)"Label - & \u00e9 \u00e1 ", (Object)layout.getLabel());
        section = (DataLayout.Section)layout.getPageLayout().get(1);
        Assert.assertEquals((Object)"section Label - & \u00e9 \u00e1 ", (Object)section.getLabel());
        DataLayout.Text text = (DataLayout.Text)layout.getPageLayout().get(2);
        Assert.assertEquals((Object)"PageText - & \u00e9 \u00e1 ", (Object)text.getText());
        section = (DataLayout.Section)layout.getPageLayout().get(3);
        Assert.assertEquals((Object)"<html>Number of Persons by<br/> Nationality and Status</html>", (Object)section.getLabel());
        text = (DataLayout.Text)layout.getPageLayout().get(4);
        Assert.assertEquals((Object)"<html><font color='red'><em>DO NOT DELAY</em></font><br/>supply further information</html>", (Object)text.getText());
        Assert.assertNotNull((Object)layout.toXML());
        output = layout.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_SPECIAL, (Object)output);
    }

    @Test
    public void testLayoutFromFile() throws Exception {
        DataFormProvider pr = new DataFormProvider();
        InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream(TEST_INPUT_1), "UTF-8");
        XmlPullParser parser = PacketParserUtils.getParserFor((Reader)inputStreamReader);
        DataForm form = (DataForm)pr.parse(parser);
        Assert.assertNotNull((Object)form);
        Assert.assertEquals((long)1L, (long)form.getExtensionElements().size());
        DataLayout layout = (DataLayout)form.getExtensionElements().get(0);
        Assert.assertEquals((long)5L, (long)layout.getPageLayout().size());
        Assert.assertEquals((Object)"Label - & \u00e9 \u00e1 ", (Object)layout.getLabel());
        DataLayout.Section section = (DataLayout.Section)layout.getPageLayout().get(1);
        Assert.assertEquals((Object)"section Label - & \u00e9 \u00e1 ", (Object)section.getLabel());
        DataLayout.Text text = (DataLayout.Text)layout.getPageLayout().get(2);
        Assert.assertEquals((Object)"PageText - & \u00e9 \u00e1 ", (Object)text.getText());
        section = (DataLayout.Section)layout.getPageLayout().get(3);
        Assert.assertEquals((Object)"<html>Number of Persons by<br/> Nationality and Status</html>", (Object)section.getLabel());
        text = (DataLayout.Text)layout.getPageLayout().get(4);
        Assert.assertEquals((Object)"<html><font color='red'><em>DO NOT DELAY</em></font><br/>supply further information</html>", (Object)text.getText());
        Assert.assertNotNull((Object)layout.toXML());
        String output = layout.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_SPECIAL, (Object)output);
    }
}

