/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation;

import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdatavalidation.ValidationConsistencyException;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataValidationHelperTest {
    @Test
    public void testCheckConsistencyFormFieldBasicValidateElement() {
        FormField.Builder field = FormField.builder((String)"var").setType(FormField.Type.jid_single);
        ValidateElement.BasicValidateElement element = new ValidateElement.BasicValidateElement(null);
        ValidationConsistencyException vce = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency(field));
        Assert.assertEquals((Object)"Field type 'jid-single' is not consistent with validation method 'basic'.", (Object)vce.getMessage());
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new ValidateElement.ListRange(Long.valueOf(-1L), Long.valueOf(1L)));
        Assert.assertEquals((Object)"unsigned 32-bit integers can't be negative", (Object)iae.getMessage());
        element.setListRange(new ValidateElement.ListRange(Long.valueOf(10L), Long.valueOf(100L)));
        vce = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency(field));
        Assert.assertEquals((Object)"Field type is not of type 'list-multi' while a 'list-range' is defined.", (Object)vce.getMessage());
        FormField.Builder fieldListMulti = field.setType(FormField.Type.list_multi);
        element.checkConsistency(fieldListMulti);
    }

    @Test
    public void testCheckConsistencyFormFieldOpenValidateElement() {
        FormField.Builder field = FormField.builder((String)"var").setType(FormField.Type.hidden);
        ValidateElement.OpenValidateElement element = new ValidateElement.OpenValidateElement(null);
        ValidationConsistencyException e = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency(field));
        Assert.assertEquals((Object)"Field type 'hidden' is not consistent with validation method 'open'.", (Object)e.getMessage());
    }

    @Test
    public void testCheckConsistencyFormFieldRangeValidateElement() {
        FormField.Builder field = FormField.builder((String)"var").setType(FormField.Type.text_multi);
        ValidateElement.RangeValidateElement element = new ValidateElement.RangeValidateElement("xs:integer", null, "99");
        ValidationConsistencyException e = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency(field));
        Assert.assertEquals((Object)"Field type 'text-multi' is not consistent with validation method 'range'.", (Object)e.getMessage());
    }

    @Test
    public void testCheckConsistencyFormFieldRegexValidateElement() {
        FormField.Builder field = FormField.builder((String)"var").setType(FormField.Type.list_multi);
        ValidateElement.RegexValidateElement element = new ValidateElement.RegexValidateElement(null, ".*");
        ValidationConsistencyException e = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency(field));
        Assert.assertEquals((Object)"Field type 'list-multi' is not consistent with validation method 'regex'.", (Object)e.getMessage());
    }
}

