/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.provider;

import java.io.IOException;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.jivesoftware.smackx.xdatavalidation.provider.DataValidationProvider;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class DataValidationTest
extends SmackTestSuite {
    private static final String TEST_INPUT_MIN = "<validate xmlns='http://jabber.org/protocol/xdata-validate'></validate>";
    private static final String TEST_OUTPUT_MIN = "<validate xmlns='http://jabber.org/protocol/xdata-validate'><basic/></validate>";
    private static final String TEST_OUTPUT_RANGE = "<validate xmlns='http://jabber.org/protocol/xdata-validate' datatype='xs:string'><range min='min-val' max='max-val'/><list-range min='111' max='999'/></validate>";
    private static final String TEST_OUTPUT_RANGE2 = "<validate xmlns='http://jabber.org/protocol/xdata-validate'><range/></validate>";
    private static final String TEST_OUTPUT_FAIL = "<validate xmlns='http://jabber.org/protocol/xdata-validate'><list-range min='1-1-1' max='999'/></validate>";

    @Test
    public void testBasic() {
        ValidateElement.BasicValidateElement dv = new ValidateElement.BasicValidateElement(null);
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_MIN, (Object)output);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testMin(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        ValidateElement dv = (ValidateElement)SmackTestUtil.parse((CharSequence)TEST_INPUT_MIN, DataValidationProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        Assert.assertNotNull((Object)dv);
        Assert.assertEquals((Object)"xs:string", (Object)dv.getDatatype());
        Assert.assertTrue((boolean)(dv instanceof ValidateElement.BasicValidateElement));
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_MIN, (Object)output);
    }

    @Test
    public void testRangeToXml() {
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement("xs:string", "min-val", "max-val");
        ValidateElement.ListRange listRange = new ValidateElement.ListRange(Long.valueOf(111L), Long.valueOf(999L));
        dv.setListRange(listRange);
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE, (Object)output);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testRange(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement("xs:string", "min-val", "max-val");
        ValidateElement.ListRange listRange = new ValidateElement.ListRange(Long.valueOf(111L), Long.valueOf(999L));
        dv.setListRange(listRange);
        String xml = dv.toXML().toString();
        dv = (ValidateElement)SmackTestUtil.parse((CharSequence)xml, DataValidationProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        Assert.assertNotNull((Object)dv);
        Assert.assertEquals((Object)"xs:string", (Object)dv.getDatatype());
        Assert.assertTrue((boolean)(dv instanceof ValidateElement.RangeValidateElement));
        ValidateElement.RangeValidateElement rdv = dv;
        Assert.assertEquals((Object)"min-val", (Object)rdv.getMin());
        Assert.assertEquals((Object)"max-val", (Object)rdv.getMax());
        Assert.assertNotNull((Object)rdv.getListRange());
        Assert.assertEquals((long)111L, (long)rdv.getListRange().getMin().nativeRepresentation());
        Assert.assertEquals((long)999L, (long)rdv.getListRange().getMax().nativeRepresentation());
        Assert.assertNotNull((Object)dv.toXML());
        xml = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE, (Object)xml);
    }

    @Test
    public void testRange2ToXml() {
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement(null, null, null);
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE2, (Object)output);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testRange2(SmackTestUtil.XmlPullParserKind parserKind) throws XmlPullParserException, IOException, SmackParsingException {
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement(null, null, null);
        String xml = dv.toXML().toString();
        dv = (ValidateElement)SmackTestUtil.parse((CharSequence)xml, DataValidationProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        Assert.assertNotNull((Object)dv);
        Assert.assertEquals((Object)"xs:string", (Object)dv.getDatatype());
        Assert.assertTrue((boolean)(dv instanceof ValidateElement.RangeValidateElement));
        ValidateElement.RangeValidateElement rdv = dv;
        Assert.assertEquals(null, (Object)rdv.getMin());
        Assert.assertEquals(null, (Object)rdv.getMax());
        Assert.assertNotNull((Object)rdv.toXML());
        xml = rdv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE2, (Object)xml);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testRangeFailure(SmackTestUtil.XmlPullParserKind parserKind) throws IOException, XmlPullParserException {
        Assertions.assertThrows(NumberFormatException.class, () -> {
            ValidateElement cfr_ignored_0 = (ValidateElement)SmackTestUtil.parse((CharSequence)TEST_OUTPUT_FAIL, DataValidationProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        });
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testNamespacePrefix(SmackTestUtil.XmlPullParserKind parserKind) throws Exception {
        String formFieldUsingNamespacePrefix = "<x xmlns='jabber:x:data'   xmlns:xdv='http://jabber.org/protocol/xdata-validate'   type='form'>  <title>Sample Form</title>  <instructions>    Please provide information for the following fields...  </instructions>  <field type='text-single' var='name' label='Event Name'/>  <field type='text-single' var='date/start' label='Starting Date'>    <xdv:validate datatype='xs:date'>      <basic/>    </xdv:validate>  </field>  <field type='text-single' var='date/end' label='Ending Date'>    <xdv:validate datatype='xs:date'>      <basic/>    </xdv:validate>  </field></x>";
        DataForm dataForm = (DataForm)SmackTestUtil.parse((CharSequence)formFieldUsingNamespacePrefix, DataFormProvider.class, (SmackTestUtil.XmlPullParserKind)parserKind);
        Assert.assertEquals((Object)"Sample Form", (Object)dataForm.getTitle());
        FormField nameField = dataForm.getField("name");
        Assert.assertEquals((Object)"Event Name", (Object)nameField.getLabel());
        FormField dataStartField = dataForm.getField("date/start");
        ValidateElement dataStartValidateElement = ValidateElement.from((FormField)dataStartField);
        Assert.assertEquals((Object)"xs:date", (Object)dataStartValidateElement.getDatatype());
        Assert.assertTrue((boolean)(dataStartValidateElement instanceof ValidateElement.BasicValidateElement));
    }
}

