/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pep;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.jidtype.AbstractJidTypeFilter;
import org.jivesoftware.smack.filter.jidtype.FromJidTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.pep.PepListener;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.filter.EventExtensionFilter;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public final class PepManager
extends Manager {
    private static final Map<XMPPConnection, PepManager> INSTANCES = new WeakHashMap<XMPPConnection, PepManager>();
    private static final StanzaFilter FROM_BARE_JID_WITH_EVENT_EXTENSION_FILTER = new AndFilter(new StanzaFilter[]{new FromJidTypeFilter(AbstractJidTypeFilter.JidType.BareJid), EventExtensionFilter.INSTANCE});
    private final Set<PepListener> pepListeners = new CopyOnWriteArraySet<PepListener>();
    private final AsyncButOrdered<EntityBareJid> asyncButOrdered = new AsyncButOrdered();
    private final PubSubManager pepPubSubManager;
    private static final PubSubFeature[] REQUIRED_FEATURES = new PubSubFeature[]{PubSubFeature.auto_create, PubSubFeature.auto_subscribe, PubSubFeature.filtered_notifications};

    public static synchronized PepManager getInstanceFor(XMPPConnection connection) {
        PepManager pepManager = INSTANCES.get(connection);
        if (pepManager == null) {
            pepManager = new PepManager(connection);
            INSTANCES.put(connection, pepManager);
        }
        return pepManager;
    }

    private PepManager(XMPPConnection connection) {
        super(connection);
        StanzaListener packetListener = new StanzaListener(){

            public void processStanza(Stanza stanza) {
                final Message message = (Message)stanza;
                final EventElement event = EventElement.from(stanza);
                assert (event != null);
                final EntityBareJid from = message.getFrom().asEntityBareJidIfPossible();
                assert (from != null);
                PepManager.this.asyncButOrdered.performAsyncButOrdered((Object)from, new Runnable(){

                    @Override
                    public void run() {
                        for (PepListener listener : PepManager.this.pepListeners) {
                            listener.eventReceived(from, event, message);
                        }
                    }
                });
            }
        };
        connection.addSyncStanzaListener(packetListener, FROM_BARE_JID_WITH_EVENT_EXTENSION_FILTER);
        this.pepPubSubManager = PubSubManager.getInstanceFor(connection, null);
    }

    public PubSubManager getPepPubSubManager() {
        return this.pepPubSubManager;
    }

    public boolean addPepListener(PepListener pepListener) {
        return this.pepListeners.add(pepListener);
    }

    public boolean removePepListener(PepListener pepListener) {
        return this.pepListeners.remove(pepListener);
    }

    public void publish(Item item, String node) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException, PubSubException.NotALeafNodeException {
        LeafNode pubSubNode = this.pepPubSubManager.getLeafNode(node);
        pubSubNode.publish(item);
    }

    public boolean isSupported() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        BareJid localBareJid = connection.getUser().asBareJid();
        return serviceDiscoveryManager.supportsFeatures((Jid)localBareJid, REQUIRED_FEATURES);
    }
}

