/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jxmpp.util.XmppDateTime;

public final class FormField
implements FullyQualifiedElement {
    public static final String ELEMENT = "field";
    public static final String NAMESPACE = "jabber:x:data";
    public static final QName QNAME = new QName("jabber:x:data", "field");
    public static final String FORM_TYPE = "FORM_TYPE";
    private final String variable;
    private final String label;
    private final Type type;
    private final List<FormFieldChildElement> formFieldChildElements;
    private final MultiMap<QName, FormFieldChildElement> formFieldChildElementsMap;
    private final List<Option> options;
    private final List<CharSequence> values;
    private final String description;
    private final boolean required;

    private MultiMap<QName, FormFieldChildElement> createChildElementsMap() {
        MultiMap formFieldChildElementsMap = new MultiMap(this.formFieldChildElements.size());
        for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
            formFieldChildElementsMap.put((Object)formFieldChildElement.getQName(), (Object)formFieldChildElement);
        }
        return formFieldChildElementsMap.asUnmodifiableMultiMap();
    }

    private FormField(String value) {
        this.variable = FORM_TYPE;
        this.type = Type.hidden;
        this.label = null;
        this.required = false;
        this.description = null;
        this.formFieldChildElements = Collections.singletonList(new Value(value));
        this.values = Collections.singletonList(value);
        this.options = Collections.emptyList();
        this.formFieldChildElementsMap = this.createChildElementsMap();
    }

    private FormField(Builder builder) {
        this.variable = builder.variable;
        this.label = builder.label;
        this.type = builder.type;
        this.formFieldChildElements = builder.formFieldChildElements != null ? Collections.unmodifiableList(builder.formFieldChildElements) : Collections.emptyList();
        if (this.variable == null && this.type != Type.fixed) {
            throw new IllegalArgumentException("The variable can only be null if the form is of type fixed");
        }
        String description = null;
        boolean requiredElementAsChild = false;
        ArrayList<Option> options = new ArrayList<Option>(this.formFieldChildElements.size());
        ArrayList<CharSequence> values = new ArrayList<CharSequence>(this.formFieldChildElements.size());
        for (FormFieldChildElement formFieldChildElement : this.formFieldChildElements) {
            if (formFieldChildElement instanceof Value) {
                Value value = (Value)formFieldChildElement;
                values.add(value.getValue());
                continue;
            }
            if (formFieldChildElement instanceof Option) {
                Option option = (Option)formFieldChildElement;
                options.add(option);
                continue;
            }
            if (formFieldChildElement instanceof Description) {
                description = ((Description)formFieldChildElement).getDescription();
                continue;
            }
            if (formFieldChildElement != Required.INSTANCE) continue;
            requiredElementAsChild = true;
        }
        options.trimToSize();
        values.trimToSize();
        this.options = Collections.unmodifiableList(options);
        this.values = Collections.unmodifiableList(values);
        this.description = description;
        this.required = requiredElementAsChild;
        this.formFieldChildElementsMap = this.createChildElementsMap();
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Type getType() {
        if (this.type == null) {
            return Type.text_single;
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CharSequence> getValues() {
        List<CharSequence> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.values));
        }
    }

    public List<String> getValuesAsString() {
        List<CharSequence> valuesAsCharSequence = this.getValues();
        ArrayList<String> res = new ArrayList<String>(valuesAsCharSequence.size());
        for (CharSequence value : valuesAsCharSequence) {
            res.add(value.toString());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFirstValue() {
        CharSequence firstValue;
        List<CharSequence> list = this.values;
        synchronized (list) {
            if (this.values.isEmpty()) {
                return null;
            }
            firstValue = this.values.get(0);
        }
        return firstValue.toString();
    }

    public Date getFirstValueAsDate() throws ParseException {
        String valueString = this.getFirstValue();
        if (valueString == null) {
            return null;
        }
        return XmppDateTime.parseXEP0082Date((String)valueString);
    }

    public String getVariable() {
        return this.variable;
    }

    public FormFieldChildElement getFormFieldChildElement(QName qname) {
        return (FormFieldChildElement)this.formFieldChildElementsMap.getFirst((Object)qname);
    }

    public List<FormFieldChildElement> getFormFieldChildElements(QName qname) {
        return this.formFieldChildElementsMap.getAll((Object)qname);
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public QName getQName() {
        return QNAME;
    }

    public Builder buildAnswer() {
        return this.asBuilder().resetValues();
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder((FullyQualifiedElement)this, enclosingNamespace);
        buf.optAttribute("label", this.getLabel());
        buf.optAttribute("var", this.getVariable());
        buf.attribute("type", (Enum)this.getType(), (Enum)Type.text_single);
        if (this.formFieldChildElements.isEmpty()) {
            buf.closeEmptyElement();
        } else {
            buf.rightAngleBracket();
            buf.append(this.formFieldChildElements, enclosingNamespace);
            buf.closeElement((NamedElement)this);
        }
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FormField)) {
            return false;
        }
        FormField other = (FormField)obj;
        return this.toXML().toString().equals(other.toXML().toString());
    }

    public int hashCode() {
        return this.toXML().toString().hashCode();
    }

    public static FormField hiddenFormType(String value) {
        return new FormField(value);
    }

    public static Builder builder(String fieldName) {
        return FormField.builder().setFieldName(fieldName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Value
    extends StandardFormFieldChildElement {
        public static final String ELEMENT = "value";
        public static final QName QNAME = new QName("jabber:x:data", "value");
        private final CharSequence value;

        public Value(CharSequence value) {
            this.value = value;
        }

        public CharSequence getValue() {
            return this.value;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xml.rightAngleBracket();
            xml.escape(this.value);
            return xml.closeElement((NamedElement)this);
        }

        public boolean equals(Object other) {
            return EqualsUtil.equals((Object)this, (Object)other, (e, o) -> e.append((Object)this.value, (Object)o.value));
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class Required
    extends StandardFormFieldChildElement {
        public static final Required INSTANCE = new Required();
        public static final String ELEMENT = "required";
        public static final QName QNAME = new QName("jabber:x:data", "required");

        private Required() {
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        @Override
        public boolean mustBeOnlyOfHisKind() {
            return true;
        }

        public String toXML(XmlEnvironment xmlEnvironment) {
            return "<required/>";
        }
    }

    public static class Description
    extends StandardFormFieldChildElement {
        public static final String ELEMENT = "desc";
        public static final QName QNAME = new QName("jabber:x:data", "desc");
        private final String description;

        public Description(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xml = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xml.rightAngleBracket();
            xml.escape(this.description);
            xml.closeElement((NamedElement)this);
            return xml;
        }
    }

    public static final class Option
    extends StandardFormFieldChildElement {
        public static final String ELEMENT = "option";
        public static final QName QNAME = new QName("jabber:x:data", "option");
        private final String label;
        private final Value value;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Option(String value) {
            this(null, value);
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = new Value(value);
        }

        public Option(String label, Value value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public Value getValue() {
            return this.value;
        }

        public String getValueString() {
            return this.value.value.toString();
        }

        public String toString() {
            return this.getLabel();
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return FormField.NAMESPACE;
        }

        public QName getQName() {
            return QNAME;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.optAttribute("label", this.getLabel());
            xml.rightAngleBracket();
            xml.element("value", this.getValueString());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals((Object)this, (Object)obj, (e, o) -> e.append((Object)this.value, (Object)o.value).append((Object)this.label, (Object)o.label));
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(c -> c.append((Object)this.value).append((Object)this.label));
        }
    }

    private static abstract class StandardFormFieldChildElement
    implements FormFieldChildElement {
        private StandardFormFieldChildElement() {
        }
    }

    public static final class Builder {
        private String variable;
        private String label;
        private Type type;
        private List<FormFieldChildElement> formFieldChildElements;
        private boolean disallowType;
        private boolean disallowFurtherFormFieldChildElements;

        private Builder() {
        }

        private Builder(FormField formField) {
            this.variable = formField.variable;
            this.label = formField.label;
            this.type = formField.type;
            this.formFieldChildElements = CollectionUtil.newListWith((Collection)formField.formFieldChildElements);
        }

        public Builder setFieldName(String fieldName) {
            return this.setVariable(fieldName);
        }

        public Builder setVariable(String variable) {
            this.variable = variable;
            return this;
        }

        public Builder setType(Type type) {
            Type oldType = this.type;
            this.type = type;
            try {
                this.checkFormFieldChildElementsConsistency();
            }
            catch (IllegalArgumentException e) {
                this.type = oldType;
                throw e;
            }
            return this;
        }

        public Builder setDescription(String description) {
            Description descriptionElement = new Description(description);
            this.setOnlyElement(descriptionElement, Description.class);
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.setOnlyElement(Required.INSTANCE, Required.class);
            return this;
        }

        public Builder addValue(CharSequence value) {
            return this.addFormFieldChildElement(new Value(value));
        }

        public Builder addValue(Date date) {
            String dateString = XmppDateTime.formatXEP0082Date((Date)date);
            return this.addValue(dateString);
        }

        public Builder addValues(Collection<? extends CharSequence> values) {
            for (CharSequence charSequence : values) {
                this.addValue(charSequence);
            }
            return this;
        }

        public Builder addOption(String option) {
            return this.addOption(new Option(option));
        }

        public Builder addOption(Option option) {
            return this.addFormFieldChildElement(option);
        }

        public Builder addFormFieldChildElement(FormFieldChildElement formFieldChildElement) {
            if (this.disallowFurtherFormFieldChildElements) {
                throw new IllegalArgumentException();
            }
            if (formFieldChildElement.requiresNoTypeSet() && this.type != null) {
                throw new IllegalArgumentException("Elements of type " + formFieldChildElement.getClass() + " can only be added to form fields where no type is set");
            }
            this.ensureThatFormFieldChildElementsIsSet();
            if (!this.formFieldChildElements.isEmpty() && formFieldChildElement.isExclusiveElement()) {
                throw new IllegalArgumentException("Elements of type " + formFieldChildElement.getClass() + " must be the only child elements of a form field.");
            }
            this.disallowType = this.disallowType || formFieldChildElement.requiresNoTypeSet();
            this.disallowFurtherFormFieldChildElements = formFieldChildElement.isExclusiveElement();
            this.formFieldChildElements.add(formFieldChildElement);
            return this;
        }

        public Builder resetValues() {
            if (this.formFieldChildElements == null) {
                return this;
            }
            Iterator<FormFieldChildElement> it = this.formFieldChildElements.iterator();
            while (it.hasNext()) {
                FormFieldChildElement formFieldChildElement = it.next();
                if (!(formFieldChildElement instanceof Value)) continue;
                it.remove();
            }
            this.disallowFurtherFormFieldChildElements = false;
            this.disallowType = false;
            return this;
        }

        public FormField build() {
            return new FormField(this);
        }

        public Type getType() {
            return this.type;
        }

        private void ensureThatFormFieldChildElementsIsSet() {
            if (this.formFieldChildElements == null) {
                this.formFieldChildElements = new ArrayList<FormFieldChildElement>(4);
            }
        }

        private <E extends FormFieldChildElement> void setOnlyElement(E element, Class<E> elementClass) {
            this.ensureThatFormFieldChildElementsIsSet();
            for (int i = 0; i < this.formFieldChildElements.size(); ++i) {
                if (!this.formFieldChildElements.get(i).getClass().equals(elementClass)) continue;
                this.formFieldChildElements.set(i, element);
                return;
            }
            this.formFieldChildElements.add(0, element);
        }

        private void checkFormFieldChildElementsConsistency() {
            if (this.formFieldChildElements == null) {
                return;
            }
            for (FormFieldChildElement formFiledChildElement : this.formFieldChildElements) {
                formFiledChildElement.checkConsistency(this);
            }
        }
    }

    public static enum Type {
        bool,
        fixed,
        hidden,
        jid_multi,
        jid_single,
        list_multi,
        list_single,
        text_multi,
        text_private,
        text_single;


        public String toString() {
            switch (this) {
                case bool: {
                    return "boolean";
                }
            }
            return this.name().replace('_', '-');
        }

        public static Type fromString(String string) {
            if (string == null) {
                return null;
            }
            switch (string) {
                case "boolean": {
                    return bool;
                }
            }
            string = string.replace('-', '_');
            return Type.valueOf(string);
        }
    }
}

