/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.test.util.CharSequenceEquals;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.iqversion.VersionManager;
import org.jivesoftware.smackx.iqversion.packet.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionTest
extends SmackTestSuite {
    @Test
    public void checkProvider() throws Exception {
        String control = "<iq from='capulet.lit' to='juliet@capulet.lit/balcony' id='s2c1' type='get'><query xmlns='jabber:iq:version'/></iq>";
        DummyConnection con = new DummyConnection();
        con.connect();
        VersionManager.setAutoAppendSmackVersion((boolean)false);
        VersionManager.getInstanceFor((XMPPConnection)con).setVersion("Test", "0.23", "DummyOS");
        IQ versionRequest = (IQ)PacketParserUtils.parseStanza((String)control);
        Assertions.assertTrue((boolean)(versionRequest instanceof Version));
        con.processStanza((Stanza)versionRequest);
        Stanza replyPacket = (Stanza)con.getSentPacket();
        Assertions.assertTrue((boolean)(replyPacket instanceof Version));
        Version reply = (Version)replyPacket;
        MatcherAssert.assertThat((Object)"capulet.lit", (Matcher)CharSequenceEquals.equalsCharSequence((CharSequence)reply.getTo()));
        Assertions.assertEquals((Object)"s2c1", (Object)reply.getStanzaId());
        Assertions.assertEquals((Object)IQ.Type.result, (Object)reply.getType());
        Assertions.assertEquals((Object)"Test", (Object)reply.getName());
        Assertions.assertEquals((Object)"0.23", (Object)reply.getVersion());
        Assertions.assertEquals((Object)"DummyOS", (Object)reply.getOs());
    }
}

