/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.mood.provider.MoodProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MoodElementTest
extends SmackTestSuite {
    @Test
    public void toXmlTest() throws Exception {
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'><happy/><text>Yay, the mood spec has been approved!</text></mood>";
        MoodElement moodElement = new MoodElement(new MoodElement.MoodSubjectElement(Mood.happy, null), "Yay, the mood spec has been approved!");
        XmlUnitUtils.assertXmlSimilar((CharSequence)xml, (CharSequence)moodElement.toXML().toString());
        Assertions.assertFalse((boolean)moodElement.hasConcretisation());
        Assertions.assertEquals((Object)Mood.happy, (Object)moodElement.getMood());
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodElement parsed = (MoodElement)MoodProvider.INSTANCE.parse(parser);
        Assertions.assertEquals((Object)xml, (Object)parsed.toXML().toString());
    }

    @Test
    public void illegalArgumentsTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MoodElement(null, "Text alone is not allowed."));
    }

    @Test
    public void emptyMoodTest() throws Exception {
        MoodElement empty = new MoodElement(null, null);
        Assertions.assertNull((Object)empty.getText());
        Assertions.assertNull((Object)empty.getMood());
        Assertions.assertNull((Object)empty.getMoodConcretisation());
        Assertions.assertFalse((boolean)empty.hasText());
        Assertions.assertFalse((boolean)empty.hasConcretisation());
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'/>";
        XmlPullParser parser = TestUtils.getParser((String)xml);
        MoodElement emptyParsed = (MoodElement)MoodProvider.INSTANCE.parse(parser);
        Assertions.assertEquals((Object)empty.toXML().toString(), (Object)emptyParsed.toXML().toString());
    }

    @Test
    public void unknownMoodValueExceptionTest() throws Exception {
        String xml = "<mood xmlns='http://jabber.org/protocol/mood'><unknown/></mood>";
        XmlPullParser parser = TestUtils.getParser((String)xml);
        Assertions.assertThrows(XmlPullParserException.class, () -> MoodProvider.INSTANCE.parse(parser));
    }
}

