/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareinfo;

import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.XmlUnitUtils;
import org.jivesoftware.smackx.mediaelement.element.MediaElement;
import org.jivesoftware.smackx.softwareinfo.form.SoftwareInfoForm;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SoftwareInfoFormTest
extends SmackTestSuite {
    private final String xml = "<x xmlns='jabber:x:data' type='result'><field var='FORM_TYPE' type='hidden'><value>urn:xmpp:dataforms:softwareinfo</value></field><field var='icon'><media xmlns='urn:xmpp:media-element' height='80' width='290'><uri type='image/jpeg'>http://www.shakespeare.lit/clients/exodus.jpg</uri><uri type='image/jpeg'>cid:sha1+f24030b8d91d233bac14777be5ab531ca3b9f102@bob.xmpp.org</uri></media></field><field var='os'><value>Windows</value></field><field var='os_version'><value>XP</value></field><field var='software'><value>Exodus</value></field><field var='software_version'><value>0.9.1</value></field></x>";

    @Test
    public void softwareInfoBuilderTest() throws URISyntaxException {
        SoftwareInfoForm softwareInfoForm = SoftwareInfoFormTest.createSoftwareInfoForm();
        XmlUnitUtils.assertXmlSimilar((CharSequence)"<x xmlns='jabber:x:data' type='result'><field var='FORM_TYPE' type='hidden'><value>urn:xmpp:dataforms:softwareinfo</value></field><field var='icon'><media xmlns='urn:xmpp:media-element' height='80' width='290'><uri type='image/jpeg'>http://www.shakespeare.lit/clients/exodus.jpg</uri><uri type='image/jpeg'>cid:sha1+f24030b8d91d233bac14777be5ab531ca3b9f102@bob.xmpp.org</uri></media></field><field var='os'><value>Windows</value></field><field var='os_version'><value>XP</value></field><field var='software'><value>Exodus</value></field><field var='software_version'><value>0.9.1</value></field></x>", (CharSequence)softwareInfoForm.getDataForm().toXML());
        softwareInfoForm = SoftwareInfoFormTest.createSoftwareInfoFormUsingDataForm();
        XmlUnitUtils.assertXmlSimilar((CharSequence)"<x xmlns='jabber:x:data' type='result'><field var='FORM_TYPE' type='hidden'><value>urn:xmpp:dataforms:softwareinfo</value></field><field var='icon'><media xmlns='urn:xmpp:media-element' height='80' width='290'><uri type='image/jpeg'>http://www.shakespeare.lit/clients/exodus.jpg</uri><uri type='image/jpeg'>cid:sha1+f24030b8d91d233bac14777be5ab531ca3b9f102@bob.xmpp.org</uri></media></field><field var='os'><value>Windows</value></field><field var='os_version'><value>XP</value></field><field var='software'><value>Exodus</value></field><field var='software_version'><value>0.9.1</value></field></x>", (CharSequence)softwareInfoForm.getDataForm().toXML());
    }

    @Test
    public void getInfoFromSoftwareInfoFormTest() throws URISyntaxException {
        SoftwareInfoForm softwareInfoForm = SoftwareInfoFormTest.createSoftwareInfoForm();
        Assertions.assertEquals((Object)"Windows", (Object)softwareInfoForm.getOS());
        Assertions.assertEquals((Object)"XP", (Object)softwareInfoForm.getOSVersion());
        Assertions.assertEquals((Object)"Exodus", (Object)softwareInfoForm.getSoftwareName());
        Assertions.assertEquals((Object)"0.9.1", (Object)softwareInfoForm.getSoftwareVersion());
        XmlUnitUtils.assertXmlSimilar((CharSequence)SoftwareInfoFormTest.createMediaElement().toXML(), (CharSequence)softwareInfoForm.getIcon().toXML());
    }

    @Test
    public void faultySoftwareInfoFormsTest() {
        DataForm.Builder dataFormbuilder = DataForm.builder((DataForm.Type)DataForm.Type.result);
        TextSingleFormField formField = FormField.buildHiddenFormType((String)"faulty_formtype");
        dataFormbuilder.addField((FormField)formField);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SoftwareInfoForm.getBuilder().setDataForm(dataFormbuilder.build()).build());
        DataForm.Builder builderWithoutFormType = DataForm.builder((DataForm.Type)DataForm.Type.result);
        Assertions.assertThrows(IllegalArgumentException.class, () -> SoftwareInfoForm.getBuilder().setDataForm(builderWithoutFormType.build()).build());
    }

    public static SoftwareInfoForm createSoftwareInfoFormUsingDataForm() throws URISyntaxException {
        DataForm.Builder dataFormBuilder = DataForm.builder((DataForm.Type)DataForm.Type.result);
        TextSingleFormField formField = FormField.buildHiddenFormType((String)"urn:xmpp:dataforms:softwareinfo");
        dataFormBuilder.addField((FormField)formField);
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"icon").addFormFieldChildElement((FormFieldChildElement)SoftwareInfoFormTest.createMediaElement())).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"os").setValue((CharSequence)"Windows")).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"os_version").setValue((CharSequence)"XP")).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"software").setValue((CharSequence)"Exodus")).build());
        dataFormBuilder.addField((FormField)((TextSingleFormField.Builder)FormField.builder((String)"software_version").setValue((CharSequence)"0.9.1")).build());
        SoftwareInfoForm softwareInfoForm = SoftwareInfoForm.getBuilder().setDataForm(dataFormBuilder.build()).build();
        return softwareInfoForm;
    }

    public static SoftwareInfoForm createSoftwareInfoForm() throws URISyntaxException {
        return SoftwareInfoForm.getBuilder().setIcon(SoftwareInfoFormTest.createMediaElement()).setOS("Windows").setOSVersion("XP").setSoftware("Exodus").setSoftwareVersion("0.9.1").build();
    }

    public static MediaElement createMediaElement() throws URISyntaxException {
        return MediaElement.builder().addUri(new URI("http://www.shakespeare.lit/clients/exodus.jpg"), "image/jpeg").addUri(new URI("cid:sha1+f24030b8d91d233bac14777be5ab531ca3b9f102@bob.xmpp.org"), "image/jpeg").setHeightAndWidth(80, 290).build();
    }
}

