/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.usertune;

import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.usertune.element.UserTuneElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UserTuneManagerTest
extends SmackTestSuite {
    @Test
    public void addMessage() throws URISyntaxException {
        UserTuneElement.Builder builder = UserTuneElement.getBuilder();
        builder.setArtist("Yes");
        builder.setLength(686);
        builder.setRating(8);
        builder.setSource("Yessongs");
        builder.setTitle("Heart of the Sunrise");
        builder.setTrack("3");
        URI uri = new URI("http://www.yesworld.com/lyrics/Fragile.html#9");
        builder.setUri(uri);
        UserTuneElement userTuneElement = builder.build();
        Message message = ((MessageBuilder)StanzaBuilder.buildMessage().addExtension((ExtensionElement)userTuneElement)).build();
        Assertions.assertTrue((boolean)message.hasExtension("tune", "http://jabber.org/protocol/tune"));
        Assertions.assertTrue((boolean)UserTuneElement.hasUserTuneElement((Message)message));
        UserTuneElement element = UserTuneElement.from((Message)message);
        Assertions.assertNotNull((Object)element);
        Assertions.assertEquals((Object)userTuneElement, (Object)element);
    }
}

