/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jivesoftware.smackx.xdatalayout.packet.DataLayout;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataFormTest
extends SmackTestSuite {
    private static final String TEST_OUTPUT_1 = "<x xmlns='jabber:x:data' type='form'><instructions>InstructionTest1</instructions><field var='testField1'/></x>";
    private static final String TEST_OUTPUT_2 = "<x xmlns='jabber:x:data' type='form'><instructions>InstructionTest1</instructions><field var='testField1'/><page xmlns='http://jabber.org/protocol/xdata-layout' label='Label'><fieldref var='testField1'/><section label='section Label'><text>SectionText</text></section><text>PageText</text></page></x>";
    private static final String TEST_OUTPUT_3 = "<x xmlns='jabber:x:data' type='form'><instructions>InstructionTest1</instructions><field var='testField1'><validate xmlns='http://jabber.org/protocol/xdata-validate' datatype='xs:integer'><range min='1111' max='9999'/></validate></field></x>";
    private static final DataFormProvider pr = new DataFormProvider();

    @Test
    public void test() throws Exception {
        DataForm.Builder df = DataForm.builder((DataForm.Type)DataForm.Type.form);
        String instruction = "InstructionTest1";
        df.addInstruction(instruction);
        TextSingleFormField field = FormField.builder((String)"testField1").build();
        df.addField((FormField)field);
        DataForm dataForm = df.build();
        String output = dataForm.toXML().toString();
        Assertions.assertEquals((Object)TEST_OUTPUT_1, (Object)output);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)output);
        dataForm = (DataForm)pr.parse(parser);
        Assertions.assertNotNull((Object)dataForm);
        Assertions.assertNotNull((Object)dataForm.getFields());
        Assertions.assertEquals((int)1, (int)dataForm.getFields().size());
        Assertions.assertEquals((int)1, (int)dataForm.getInstructions().size());
        output = dataForm.toXML().toString();
        Assertions.assertEquals((Object)TEST_OUTPUT_1, (Object)output);
    }

    @Test
    public void testLayout() throws Exception {
        DataForm.Builder df = DataForm.builder((DataForm.Type)DataForm.Type.form);
        String instruction = "InstructionTest1";
        df.addInstruction(instruction);
        TextSingleFormField field = FormField.builder((String)"testField1").build();
        df.addField((FormField)field);
        DataLayout layout = new DataLayout("Label");
        DataLayout.Fieldref reffield = new DataLayout.Fieldref("testField1");
        layout.getPageLayout().add(reffield);
        DataLayout.Section section = new DataLayout.Section("section Label");
        section.getSectionLayout().add(new DataLayout.Text("SectionText"));
        layout.getPageLayout().add(section);
        layout.getPageLayout().add(new DataLayout.Text("PageText"));
        df.addExtensionElement((Element)layout);
        DataForm dataForm = df.build();
        String output = dataForm.toXML().toString();
        Assertions.assertEquals((Object)TEST_OUTPUT_2, (Object)output);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)output);
        dataForm = (DataForm)pr.parse(parser);
        Assertions.assertNotNull((Object)dataForm.getExtensionElements());
        Assertions.assertEquals((int)1, (int)dataForm.getExtensionElements().size());
        Element element = (Element)dataForm.getExtensionElements().get(0);
        Assertions.assertNotNull((Object)element);
        layout = (DataLayout)element;
        Assertions.assertEquals((int)3, (int)layout.getPageLayout().size());
        output = dataForm.toXML().toString();
        Assertions.assertEquals((Object)TEST_OUTPUT_2, (Object)output);
    }

    @Test
    public void testValidation() throws Exception {
        DataForm.Builder df = DataForm.builder((DataForm.Type)DataForm.Type.form);
        String instruction = "InstructionTest1";
        df.addInstruction(instruction);
        TextSingleFormField.Builder fieldBuilder = FormField.builder((String)"testField1");
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement("xs:integer", "1111", "9999");
        fieldBuilder.addFormFieldChildElement((FormFieldChildElement)dv);
        df.addField(fieldBuilder.build());
        DataForm dataForm = df.build();
        String output = dataForm.toXML().toString();
        Assertions.assertEquals((Object)TEST_OUTPUT_3, (Object)output);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)output);
        dataForm = (DataForm)pr.parse(parser);
        Assertions.assertNotNull((Object)dataForm.getFields());
        Assertions.assertEquals((int)1, (int)dataForm.getFields().size());
        ValidateElement element = ValidateElement.from((FormField)((FormField)dataForm.getFields().get(0)));
        Assertions.assertNotNull((Object)element);
        dv = element;
        Assertions.assertEquals((Object)"xs:integer", (Object)dv.getDatatype());
        output = dataForm.toXML().toString();
        Assertions.assertEquals((Object)TEST_OUTPUT_3, (Object)output);
    }

    @Test
    public void testFixedField() throws Exception {
        String formWithFixedField = "<x xmlns='jabber:x:data' type='form'><instructions>InstructionTest1</instructions><field type='fixed'><value>Fixed field value</value></field></x>";
        DataForm df = (DataForm)pr.parse(PacketParserUtils.getParserFor((String)"<x xmlns='jabber:x:data' type='form'><instructions>InstructionTest1</instructions><field type='fixed'><value>Fixed field value</value></field></x>"));
        Assertions.assertEquals((Object)FormField.Type.fixed, (Object)((FormField)df.getFields().get(0)).getType());
    }
}

