/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation;

import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.TextMultiFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdatavalidation.ValidationConsistencyException;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataValidationHelperTest {
    @Test
    public void testCheckConsistencyFormFieldBasicValidateElement() {
        JidSingleFormField.Builder field = FormField.jidSingleBuilder((String)"var");
        ValidateElement.BasicValidateElement element = new ValidateElement.BasicValidateElement(null);
        ValidationConsistencyException vce = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency((FormField.Builder)field));
        Assertions.assertEquals((Object)"Field type 'jid-single' is not consistent with validation method 'basic'.", (Object)vce.getMessage());
        IllegalArgumentException iae = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new ValidateElement.ListRange(Long.valueOf(-1L), Long.valueOf(1L)));
        Assertions.assertEquals((Object)"unsigned 32-bit integers can't be negative", (Object)iae.getMessage());
        element.setListRange(new ValidateElement.ListRange(Long.valueOf(10L), Long.valueOf(100L)));
        vce = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> element.checkConsistency((FormField.Builder)field));
        Assertions.assertEquals((Object)"Field type is not of type 'list-multi' while a 'list-range' is defined.", (Object)vce.getMessage());
        ListMultiFormField.Builder fieldListMulti = FormField.listMultiBuilder((String)"var");
        element.checkConsistency((FormField.Builder)fieldListMulti);
    }

    @Test
    public void testCheckConsistencyFormFieldOpenValidateElement() {
        TextSingleFormField.Builder field = FormField.hiddenBuilder((String)"var");
        ValidateElement.OpenValidateElement element = new ValidateElement.OpenValidateElement(null);
        ValidationConsistencyException e = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> DataValidationHelperTest.lambda$testCheckConsistencyFormFieldOpenValidateElement$3(element, (FormField.Builder)field));
        Assertions.assertEquals((Object)"Field type 'hidden' is not consistent with validation method 'open'.", (Object)e.getMessage());
    }

    @Test
    public void testCheckConsistencyFormFieldRangeValidateElement() {
        TextMultiFormField.Builder field = FormField.textMultiBuilder((String)"var");
        ValidateElement.RangeValidateElement element = new ValidateElement.RangeValidateElement("xs:integer", null, "99");
        ValidationConsistencyException e = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> DataValidationHelperTest.lambda$testCheckConsistencyFormFieldRangeValidateElement$4(element, (FormField.Builder)field));
        Assertions.assertEquals((Object)"Field type 'text-multi' is not consistent with validation method 'range'.", (Object)e.getMessage());
    }

    @Test
    public void testCheckConsistencyFormFieldRegexValidateElement() {
        ListMultiFormField.Builder field = FormField.listMultiBuilder((String)"var");
        ValidateElement.RegexValidateElement element = new ValidateElement.RegexValidateElement(null, ".*");
        ValidationConsistencyException e = (ValidationConsistencyException)Assertions.assertThrows(ValidationConsistencyException.class, () -> DataValidationHelperTest.lambda$testCheckConsistencyFormFieldRegexValidateElement$5(element, (FormField.Builder)field));
        Assertions.assertEquals((Object)"Field type 'list-multi' is not consistent with validation method 'regex'.", (Object)e.getMessage());
    }

    private static /* synthetic */ void lambda$testCheckConsistencyFormFieldRegexValidateElement$5(ValidateElement.RegexValidateElement element, FormField.Builder field) throws Throwable {
        element.checkConsistency(field);
    }

    private static /* synthetic */ void lambda$testCheckConsistencyFormFieldRangeValidateElement$4(ValidateElement.RangeValidateElement element, FormField.Builder field) throws Throwable {
        element.checkConsistency(field);
    }

    private static /* synthetic */ void lambda$testCheckConsistencyFormFieldOpenValidateElement$3(ValidateElement.OpenValidateElement element, FormField.Builder field) throws Throwable {
        element.checkConsistency(field);
    }
}

