/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import org.jivesoftware.smack.util.StringUtils;

public class BoBHash {
    private final String hash;
    private final String hashType;
    private final String cid;

    public BoBHash(String hash, String hashType) {
        this.hash = (String)StringUtils.requireNotNullNorEmpty((CharSequence)hash, (String)"hash must not be null nor empty");
        this.hashType = (String)StringUtils.requireNotNullNorEmpty((CharSequence)hashType, (String)"hashType must not be null nor empty");
        this.cid = this.hashType + '+' + this.hash + "@bob.xmpp.org";
    }

    public String getHash() {
        return this.hash;
    }

    public String getHashType() {
        return this.hashType;
    }

    public String toSrc() {
        return "cid:" + this.getCid();
    }

    public String getCid() {
        return this.cid;
    }

    public boolean equals(Object other) {
        if (other instanceof BoBHash) {
            BoBHash otherBob = (BoBHash)other;
            return this.cid.equals(otherBob.cid);
        }
        return false;
    }

    public int hashCode() {
        return this.cid.hashCode();
    }

    public static BoBHash fromSrc(String src) {
        String hashType = src.substring(src.lastIndexOf("cid:") + 4, src.indexOf("+"));
        String hash = src.substring(src.indexOf("+") + 1, src.indexOf("@bob.xmpp.org"));
        return new BoBHash(hash, hashType);
    }

    public static BoBHash fromCid(String cid) {
        String hashType = cid.substring(0, cid.indexOf("+"));
        String hash = cid.substring(cid.indexOf("+") + 1, cid.indexOf("@bob.xmpp.org"));
        return new BoBHash(hash, hashType);
    }
}

