/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractPresenceEventListener;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.caps.CapsVersionAndHash;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.DiscoInfoLookupShortcutMechanism;
import org.jivesoftware.smackx.disco.EntityCapabilitiesChangedListener;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.util.cache.LruCache;

public final class EntityCapsManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    private static final String DEFAULT_HASH = "SHA-1";
    private static String DEFAULT_ENTITY_NODE = "https://igniterealtime.org/projects/smack";
    protected static EntityCapsPersistentCache persistentCache;
    private static boolean autoEnableEntityCaps;
    private static final Map<XMPPConnection, EntityCapsManager> instances;
    private static final StanzaFilter PRESENCES_WITH_CAPS;
    static final LruCache<String, DiscoverInfo> CAPS_CACHE;
    static final LruCache<Jid, NodeVerHash> JID_TO_NODEVER_CACHE;
    private final Queue<CapsVersionAndHash> lastLocalCapsVersions = new ConcurrentLinkedQueue<CapsVersionAndHash>();
    private final ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private CapsVersionAndHash currentCapsVersion;
    private String entityNode = DEFAULT_ENTITY_NODE;
    private final Consumer<PresenceBuilder> presenceInterceptor = presenceBuilder -> {
        CapsVersionAndHash capsVersionAndHash = this.getCapsVersionAndHash();
        CapsExtension caps = new CapsExtension(this.entityNode, capsVersionAndHash.version, capsVersionAndHash.hash);
        presenceBuilder.overrideExtension((ExtensionElement)caps);
    };

    public static void setDefaultEntityNode(String entityNode) {
        DEFAULT_ENTITY_NODE = entityNode;
    }

    static void addDiscoverInfoByNode(String nodeVer, DiscoverInfo info) {
        CAPS_CACHE.put((Object)nodeVer, (Object)info);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(nodeVer, info);
        }
    }

    public static String getNodeVersionByJid(Jid jid) {
        NodeVerHash nvh = (NodeVerHash)JID_TO_NODEVER_CACHE.lookup((Object)jid);
        if (nvh != null) {
            return nvh.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(Jid jid) {
        return (NodeVerHash)JID_TO_NODEVER_CACHE.lookup((Object)jid);
    }

    public static DiscoverInfo getDiscoverInfoByUser(Jid user) {
        NodeVerHash nvh = (NodeVerHash)JID_TO_NODEVER_CACHE.lookup((Object)user);
        if (nvh == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nvh.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String nodeVer) {
        DiscoverInfo info = (DiscoverInfo)CAPS_CACHE.lookup((Object)nodeVer);
        if (info == null && persistentCache != null && (info = persistentCache.lookup(nodeVer)) != null) {
            CAPS_CACHE.put((Object)nodeVer, (Object)info);
        }
        if (info != null) {
            info = new DiscoverInfo(info);
        }
        return info;
    }

    public static void setPersistentCache(EntityCapsPersistentCache cache) {
        persistentCache = cache;
    }

    public static void setMaxsCacheSizes(int maxJidToNodeVerSize, int maxCapsCacheSize) {
        JID_TO_NODEVER_CACHE.setMaxCacheSize(maxJidToNodeVerSize);
        CAPS_CACHE.setMaxCacheSize(maxCapsCacheSize);
    }

    public static void clearMemoryCache() {
        JID_TO_NODEVER_CACHE.clear();
        CAPS_CACHE.clear();
    }

    private static void addCapsExtensionInfo(Jid from, CapsExtension capsExtension) {
        String capsExtensionHash = capsExtension.getHash();
        String hashInUppercase = capsExtensionHash.toUpperCase(Locale.US);
        if (!SUPPORTED_HASHES.containsKey(hashInUppercase)) {
            return;
        }
        String hash = capsExtensionHash.toLowerCase(Locale.US);
        String node = capsExtension.getNode();
        String ver = capsExtension.getVer();
        JID_TO_NODEVER_CACHE.put((Object)from, (Object)new NodeVerHash(node, ver, hash));
    }

    private EntityCapsManager(XMPPConnection connection) {
        super(connection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        instances.put(connection, this);
        connection.addConnectionListener(new ConnectionListener(){

            public void connected(XMPPConnection connection) {
                this.processCapsStreamFeatureIfAvailable(connection);
            }

            public void authenticated(XMPPConnection connection, boolean resumed) {
                this.processCapsStreamFeatureIfAvailable(connection);
            }

            private void processCapsStreamFeatureIfAvailable(XMPPConnection connection) {
                CapsExtension capsExtension = (CapsExtension)connection.getFeature(EntityCapsManager.ELEMENT, EntityCapsManager.NAMESPACE);
                if (capsExtension == null) {
                    return;
                }
                DomainBareJid from = connection.getXMPPServiceDomain();
                EntityCapsManager.addCapsExtensionInfo((Jid)from, capsExtension);
            }
        });
        if (autoEnableEntityCaps) {
            this.enableEntityCaps();
        }
        connection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza packet) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension capsExtension = CapsExtension.from(packet);
                Jid from = packet.getFrom();
                EntityCapsManager.addCapsExtensionInfo(from, capsExtension);
            }
        }, PRESENCES_WITH_CAPS);
        Roster.getInstanceFor((XMPPConnection)connection).addPresenceEventListener((PresenceEventListener)new AbstractPresenceEventListener(){

            public void presenceUnavailable(FullJid from, Presence presence) {
                JID_TO_NODEVER_CACHE.remove((Object)from);
            }
        });
        this.sdm.addEntityCapabilitiesChangedListener(new EntityCapabilitiesChangedListener(){

            @Override
            public void onEntityCapabilitiesChanged(DiscoverInfo synthesizedDiscoveryInfo) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                EntityCapsManager.this.updateLocalEntityCaps(synthesizedDiscoveryInfo);
            }
        });
    }

    public static synchronized EntityCapsManager getInstanceFor(XMPPConnection connection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(connection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(connection);
        }
        return entityCapsManager;
    }

    public synchronized void enableEntityCaps() {
        this.connection().addPresenceInterceptor(this.presenceInterceptor, p -> PresenceTypeFilter.AVAILABLE.accept((Stanza)p));
        this.sdm.addFeature(NAMESPACE);
        this.entityCapsEnabled = true;
    }

    public synchronized void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
        this.connection().removePresenceInterceptor(this.presenceInterceptor);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public static void removeUserCapsNode(Jid user) {
        JID_TO_NODEVER_CACHE.remove((Object)user);
    }

    public CapsVersionAndHash getCapsVersionAndHash() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        CapsVersionAndHash capsVersionAndHash = this.getCapsVersionAndHash();
        if (capsVersionAndHash == null) {
            return null;
        }
        return this.entityNode + '#' + capsVersionAndHash.version;
    }

    public boolean areEntityCapsSupported(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.sdm.supportsFeature(jid, NAMESPACE);
    }

    public boolean areEntityCapsSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.areEntityCapsSupported((Jid)this.connection().getXMPPServiceDomain());
    }

    private void updateLocalEntityCaps(DiscoverInfo synthesizedDiscoveryInfo) {
        XMPPConnection connection = this.connection();
        DiscoverInfoBuilder discoverInfoBuilder = synthesizedDiscoveryInfo.asBuilder();
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfoBuilder);
        String localNodeVer = this.getLocalNodeVer();
        discoverInfoBuilder.setNode(localNodeVer);
        DiscoverInfo discoverInfo = discoverInfoBuilder.build();
        EntityCapsManager.addDiscoverInfoByNode(localNodeVer, discoverInfo);
        if (this.lastLocalCapsVersions.size() > 10) {
            CapsVersionAndHash oldCapsVersion = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider(this.entityNode + '#' + oldCapsVersion.version);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        if (connection != null) {
            JID_TO_NODEVER_CACHE.put((Object)connection.getUser(), (Object)new NodeVerHash(this.entityNode, this.currentCapsVersion));
        }
        final LinkedList<DiscoverInfo.Identity> identities = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(connection).getIdentities());
        this.sdm.setNodeInformationProvider(localNodeVer, new AbstractNodeInformationProvider(){
            List<String> features;
            List<DataForm> packetExtensions;
            {
                this.features = EntityCapsManager.this.sdm.getFeatures();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfo();
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return identities;
            }

            public List<DataForm> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
    }

    public static boolean verifyDiscoverInfoVersion(String ver, String hash, DiscoverInfo info) {
        if (info.containsDuplicateIdentities()) {
            return false;
        }
        if (info.containsDuplicateFeatures()) {
            return false;
        }
        if (!EntityCapsManager.verifyPacketExtensions(info)) {
            return false;
        }
        String calculatedVer = EntityCapsManager.generateVerificationString((DiscoverInfoView)info, (String)hash).version;
        return ver.equals(calculatedVer);
    }

    private static boolean verifyPacketExtensions(DiscoverInfo info) {
        HashSet<String> foundFormTypes = new HashSet<String>();
        List dataForms = info.getExtensions(DataForm.class);
        for (DataForm dataForm : dataForms) {
            String type;
            boolean noDuplicate;
            TextSingleFormField formFieldTypeField = dataForm.getHiddenFormTypeField();
            if (formFieldTypeField == null || (noDuplicate = foundFormTypes.add(type = formFieldTypeField.getFirstValue()))) continue;
            return false;
        }
        return true;
    }

    protected static CapsVersionAndHash generateVerificationString(DiscoverInfoView discoverInfo) {
        return EntityCapsManager.generateVerificationString(discoverInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CapsVersionAndHash generateVerificationString(DiscoverInfoView discoverInfo, String hash) {
        byte[] digest;
        Object fs;
        MessageDigest md;
        if (hash == null) {
            hash = DEFAULT_HASH;
        }
        if ((md = SUPPORTED_HASHES.get(hash.toUpperCase(Locale.US))) == null) {
            return null;
        }
        hash = hash.toLowerCase(Locale.US);
        StringBuilder sb = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> sortedIdentities = new TreeSet<DiscoverInfo.Identity>();
        sortedIdentities.addAll(discoverInfo.getIdentities());
        for (DiscoverInfo.Identity identity : sortedIdentities) {
            sb.append(identity.getCategory());
            sb.append('/');
            sb.append(identity.getType());
            sb.append('/');
            sb.append(identity.getLanguage() == null ? "" : identity.getLanguage());
            sb.append('/');
            sb.append(identity.getName() == null ? "" : identity.getName());
            sb.append('<');
        }
        TreeSet<String> features = new TreeSet<String>();
        for (DiscoverInfo.Feature feature : discoverInfo.getFeatures()) {
            features.add(feature.getVar());
        }
        for (String string : features) {
            sb.append(string);
            sb.append('<');
        }
        List list = discoverInfo.getExtensions(DataForm.class);
        for (DataForm extendedInfo : list) {
            if (!extendedInfo.hasHiddenFormTypeField()) continue;
            fs = new TreeSet<FormField>(new Comparator<FormField>(){

                @Override
                public int compare(FormField f1, FormField f2) {
                    return f1.getFieldName().compareTo(f2.getFieldName());
                }
            });
            for (FormField f : extendedInfo.getFields()) {
                if (f.getFieldName().equals("FORM_TYPE")) continue;
                fs.add(f);
            }
            EntityCapsManager.formFieldValuesToCaps(Collections.singletonList(extendedInfo.getFormType()), sb);
            Iterator<FormField> iterator = fs.iterator();
            while (iterator.hasNext()) {
                FormField f;
                f = iterator.next();
                sb.append(f.getFieldName());
                sb.append('<');
                EntityCapsManager.formFieldValuesToCaps(f.getValues(), sb);
            }
        }
        byte[] byArray = sb.toString().getBytes(StandardCharsets.UTF_8);
        fs = md;
        synchronized (fs) {
            digest = md.digest(byArray);
        }
        String version = Base64.encodeToString((byte[])digest);
        return new CapsVersionAndHash(version, hash);
    }

    private static void formFieldValuesToCaps(List<? extends CharSequence> i, StringBuilder sb) {
        TreeSet<? extends CharSequence> fvs = new TreeSet<CharSequence>();
        fvs.addAll(i);
        for (CharSequence charSequence : fvs) {
            sb.append(charSequence);
            sb.append('<');
        }
    }

    static {
        autoEnableEntityCaps = true;
        instances = new WeakHashMap<XMPPConnection, EntityCapsManager>();
        PRESENCES_WITH_CAPS = new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Presence.class), new StanzaExtensionFilter(ELEMENT, NAMESPACE)});
        CAPS_CACHE = new LruCache(1000);
        JID_TO_NODEVER_CACHE = new LruCache(10000);
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                EntityCapsManager.getInstanceFor(connection);
            }
        });
        try {
            MessageDigest sha1MessageDigest = MessageDigest.getInstance(DEFAULT_HASH);
            SUPPORTED_HASHES.put(DEFAULT_HASH, sha1MessageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        ServiceDiscoveryManager.addDiscoInfoLookupShortcutMechanism(new DiscoInfoLookupShortcutMechanism("XEP-0115: Entity Capabilities", 100){

            @Override
            public DiscoverInfo getDiscoverInfoByUser(ServiceDiscoveryManager serviceDiscoveryManager, Jid jid) {
                DiscoverInfo info = EntityCapsManager.getDiscoverInfoByUser(jid);
                if (info != null) {
                    return info;
                }
                NodeVerHash nodeVerHash = EntityCapsManager.getNodeVerHashByJid(jid);
                if (nodeVerHash == null) {
                    return null;
                }
                try {
                    info = serviceDiscoveryManager.discoverInfo(jid, nodeVerHash.getNodeVer());
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    return null;
                }
                if (EntityCapsManager.verifyDiscoverInfoVersion(nodeVerHash.getVer(), nodeVerHash.getHash(), info)) {
                    EntityCapsManager.addDiscoverInfoByNode(nodeVerHash.getNodeVer(), info);
                }
                return info;
            }
        });
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String node, CapsVersionAndHash capsVersionAndHash) {
            this(node, capsVersionAndHash.version, capsVersionAndHash.hash);
        }

        NodeVerHash(String node, String ver, String hash) {
            this.node = node;
            this.ver = ver;
            this.hash = hash;
            this.nodeVer = node + "#" + ver;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

