/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.Jid;

public class JidMultiFormField
extends FormField {
    private final List<Jid> values;

    protected JidMultiFormField(Builder builder) {
        super(builder);
        this.values = CollectionUtil.cloneAndSeal((Collection)builder.values);
    }

    public List<Jid> getValues() {
        return this.values;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public static final class Builder
    extends FormField.Builder<JidMultiFormField, Builder> {
        private List<Jid> values;

        private Builder(JidMultiFormField jidMultiFormField) {
            super(jidMultiFormField);
            this.values = CollectionUtil.newListWith(jidMultiFormField.getValues());
        }

        Builder(String fieldName) {
            super(fieldName, FormField.Type.jid_multi);
        }

        private void ensureValuesAreInitialized() {
            if (this.values == null) {
                this.values = new ArrayList<Jid>();
            }
        }

        @Override
        protected void resetInternal() {
            this.values = null;
        }

        public Builder addValue(Jid jid) {
            this.ensureValuesAreInitialized();
            this.values.add(jid);
            return this;
        }

        public Builder addValues(Collection<? extends Jid> jids) {
            this.ensureValuesAreInitialized();
            this.values.addAll(jids);
            return this;
        }

        @Override
        public JidMultiFormField build() {
            return new JidMultiFormField(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

